package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireClientDisconnectedEvent.builder()}.
 */
@Generated(from = "QuestionnaireEvent.QuestionnaireClientDisconnectedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableQuestionnaireClientDisconnectedEvent
    implements QuestionnaireEvent.QuestionnaireClientDisconnectedEvent {
  private final String questionnaireId;
  private final InetAddress client;
  private final int closeStatus;

  private ImmutableQuestionnaireClientDisconnectedEvent(String questionnaireId, InetAddress client, int closeStatus) {
    this.questionnaireId = questionnaireId;
    this.client = client;
    this.closeStatus = closeStatus;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public InetAddress getClient() {
    return client;
  }

  /**
   * @return The value of the {@code closeStatus} attribute
   */
  @Override
  public int getCloseStatus() {
    return closeStatus;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireClientDisconnectedEvent(newValue, this.client, this.closeStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withClient(InetAddress value) {
    if (this.client == value) return this;
    InetAddress newValue = Objects.requireNonNull(value, "client");
    return new ImmutableQuestionnaireClientDisconnectedEvent(this.questionnaireId, newValue, this.closeStatus);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getCloseStatus() closeStatus} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for closeStatus
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientDisconnectedEvent withCloseStatus(int value) {
    if (this.closeStatus == value) return this;
    return new ImmutableQuestionnaireClientDisconnectedEvent(this.questionnaireId, this.client, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireClientDisconnectedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireClientDisconnectedEvent
        && equalTo((ImmutableQuestionnaireClientDisconnectedEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireClientDisconnectedEvent another) {
    return questionnaireId.equals(another.questionnaireId)
        && client.equals(another.client)
        && closeStatus == another.closeStatus;
  }

  /**
   * Computes a hash code from attributes: {@code questionnaireId}, {@code client}, {@code closeStatus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + questionnaireId.hashCode();
    h += (h << 5) + client.hashCode();
    h += (h << 5) + closeStatus;
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireClientDisconnectedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QuestionnaireClientDisconnectedEvent")
        .omitNullValues()
        .add("questionnaireId", questionnaireId)
        .add("client", client)
        .add("closeStatus", closeStatus)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireClientDisconnectedEvent instance
   */
  public static ImmutableQuestionnaireClientDisconnectedEvent copyOf(QuestionnaireEvent.QuestionnaireClientDisconnectedEvent instance) {
    if (instance instanceof ImmutableQuestionnaireClientDisconnectedEvent) {
      return (ImmutableQuestionnaireClientDisconnectedEvent) instance;
    }
    return ImmutableQuestionnaireClientDisconnectedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireClientDisconnectedEvent ImmutableQuestionnaireClientDisconnectedEvent}.
   * <pre>
   * ImmutableQuestionnaireClientDisconnectedEvent.builder()
   *    .questionnaireId(String) // required {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getQuestionnaireId() questionnaireId}
   *    .client(java.net.InetAddress) // required {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getClient() client}
   *    .closeStatus(int) // required {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getCloseStatus() closeStatus}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireClientDisconnectedEvent builder
   */
  public static ImmutableQuestionnaireClientDisconnectedEvent.Builder builder() {
    return new ImmutableQuestionnaireClientDisconnectedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireClientDisconnectedEvent ImmutableQuestionnaireClientDisconnectedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireEvent.QuestionnaireClientDisconnectedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x1L;
    private static final long INIT_BIT_CLIENT = 0x2L;
    private static final long INIT_BIT_CLOSE_STATUS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String questionnaireId;
    private @Nullable InetAddress client;
    private int closeStatus;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent.QuestionnaireClientDisconnectedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent.QuestionnaireClientDisconnectedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof QuestionnaireEvent.QuestionnaireClientDisconnectedEvent) {
        QuestionnaireEvent.QuestionnaireClientDisconnectedEvent instance = (QuestionnaireEvent.QuestionnaireClientDisconnectedEvent) object;
        client(instance.getClient());
        closeStatus(instance.getCloseStatus());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder client(InetAddress client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireClientDisconnectedEvent#getCloseStatus() closeStatus} attribute.
     * @param closeStatus The value for closeStatus 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder closeStatus(int closeStatus) {
      this.closeStatus = closeStatus;
      initBits &= ~INIT_BIT_CLOSE_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireClientDisconnectedEvent ImmutableQuestionnaireClientDisconnectedEvent}.
     * @return An immutable instance of QuestionnaireClientDisconnectedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireClientDisconnectedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireClientDisconnectedEvent(questionnaireId, client, closeStatus);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_CLOSE_STATUS) != 0) attributes.add("closeStatus");
      return "Cannot build QuestionnaireClientDisconnectedEvent, some of required attributes are not set " + attributes;
    }
  }
}
