package io.dialob.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.Form;
import io.dialob.api.questionnaire.Questionnaire;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobInMemoryFill.FillCacheEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFillCacheEntry.builder()}.
 */
@Generated(from = "DialobInMemoryFill.FillCacheEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableFillCacheEntry implements DialobInMemoryFill.FillCacheEntry {
  private final String id;
  private final Questionnaire questionnaire;
  private final Form form;

  private ImmutableFillCacheEntry(
      String id,
      Questionnaire questionnaire,
      Form form) {
    this.id = id;
    this.questionnaire = questionnaire;
    this.form = form;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code questionnaire} attribute
   */
  @Override
  public Questionnaire getQuestionnaire() {
    return questionnaire;
  }

  /**
   * @return The value of the {@code form} attribute
   */
  @Override
  public Form getForm() {
    return form;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobInMemoryFill.FillCacheEntry#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFillCacheEntry withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableFillCacheEntry(newValue, this.questionnaire, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobInMemoryFill.FillCacheEntry#getQuestionnaire() questionnaire} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaire
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFillCacheEntry withQuestionnaire(Questionnaire value) {
    if (this.questionnaire == value) return this;
    Questionnaire newValue = Objects.requireNonNull(value, "questionnaire");
    return new ImmutableFillCacheEntry(this.id, newValue, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobInMemoryFill.FillCacheEntry#getForm() form} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for form
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFillCacheEntry withForm(Form value) {
    if (this.form == value) return this;
    Form newValue = Objects.requireNonNull(value, "form");
    return new ImmutableFillCacheEntry(this.id, this.questionnaire, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFillCacheEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFillCacheEntry
        && equalTo((ImmutableFillCacheEntry) another);
  }

  private boolean equalTo(ImmutableFillCacheEntry another) {
    return id.equals(another.id)
        && questionnaire.equals(another.questionnaire)
        && form.equals(another.form);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code questionnaire}, {@code form}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + questionnaire.hashCode();
    h += (h << 5) + form.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FillCacheEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FillCacheEntry")
        .omitNullValues()
        .add("id", id)
        .add("questionnaire", questionnaire)
        .add("form", form)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobInMemoryFill.FillCacheEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FillCacheEntry instance
   */
  public static ImmutableFillCacheEntry copyOf(DialobInMemoryFill.FillCacheEntry instance) {
    if (instance instanceof ImmutableFillCacheEntry) {
      return (ImmutableFillCacheEntry) instance;
    }
    return ImmutableFillCacheEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFillCacheEntry ImmutableFillCacheEntry}.
   * <pre>
   * ImmutableFillCacheEntry.builder()
   *    .id(String) // required {@link DialobInMemoryFill.FillCacheEntry#getId() id}
   *    .questionnaire(io.dialob.api.questionnaire.Questionnaire) // required {@link DialobInMemoryFill.FillCacheEntry#getQuestionnaire() questionnaire}
   *    .form(io.dialob.api.form.Form) // required {@link DialobInMemoryFill.FillCacheEntry#getForm() form}
   *    .build();
   * </pre>
   * @return A new ImmutableFillCacheEntry builder
   */
  public static ImmutableFillCacheEntry.Builder builder() {
    return new ImmutableFillCacheEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFillCacheEntry ImmutableFillCacheEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobInMemoryFill.FillCacheEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_QUESTIONNAIRE = 0x2L;
    private static final long INIT_BIT_FORM = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable Questionnaire questionnaire;
    private @Nullable Form form;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FillCacheEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobInMemoryFill.FillCacheEntry instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      questionnaire(instance.getQuestionnaire());
      form(instance.getForm());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobInMemoryFill.FillCacheEntry#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobInMemoryFill.FillCacheEntry#getQuestionnaire() questionnaire} attribute.
     * @param questionnaire The value for questionnaire 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionnaire(Questionnaire questionnaire) {
      this.questionnaire = Objects.requireNonNull(questionnaire, "questionnaire");
      initBits &= ~INIT_BIT_QUESTIONNAIRE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobInMemoryFill.FillCacheEntry#getForm() form} attribute.
     * @param form The value for form 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder form(Form form) {
      this.form = Objects.requireNonNull(form, "form");
      initBits &= ~INIT_BIT_FORM;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFillCacheEntry ImmutableFillCacheEntry}.
     * @return An immutable instance of FillCacheEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFillCacheEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFillCacheEntry(id, questionnaire, form);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_QUESTIONNAIRE) != 0) attributes.add("questionnaire");
      if ((initBits & INIT_BIT_FORM) != 0) attributes.add("form");
      return "Cannot build FillCacheEntry, some of required attributes are not set " + attributes;
    }
  }
}
