package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.UpdateStoreEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateStoreEntity.builder()}.
 */
@Generated(from = "DialobStore.UpdateStoreEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateStoreEntity implements DialobStore.UpdateStoreEntity {
  private final DialobDocument.DocumentType bodyType;
  private final String id;
  private final String version;
  private final String body;

  private ImmutableUpdateStoreEntity(
      DialobDocument.DocumentType bodyType,
      String id,
      String version,
      String body) {
    this.bodyType = bodyType;
    this.id = id;
    this.version = version;
    this.body = body;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public DialobDocument.DocumentType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public String getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.UpdateStoreEntity#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStoreEntity withBodyType(DialobDocument.DocumentType value) {
    if (this.bodyType == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableUpdateStoreEntity(newValue, this.id, this.version, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.UpdateStoreEntity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStoreEntity withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUpdateStoreEntity(this.bodyType, newValue, this.version, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.UpdateStoreEntity#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStoreEntity withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableUpdateStoreEntity(this.bodyType, this.id, newValue, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.UpdateStoreEntity#getBody() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStoreEntity withBody(String value) {
    String newValue = Objects.requireNonNull(value, "body");
    if (this.body.equals(newValue)) return this;
    return new ImmutableUpdateStoreEntity(this.bodyType, this.id, this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateStoreEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateStoreEntity
        && equalTo((ImmutableUpdateStoreEntity) another);
  }

  private boolean equalTo(ImmutableUpdateStoreEntity another) {
    return bodyType.equals(another.bodyType)
        && id.equals(another.id)
        && version.equals(another.version)
        && body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code bodyType}, {@code id}, {@code version}, {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateStoreEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpdateStoreEntity")
        .omitNullValues()
        .add("bodyType", bodyType)
        .add("id", id)
        .add("version", version)
        .add("body", body)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.UpdateStoreEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.UpdateStoreEntity {
    @Nullable DialobDocument.DocumentType bodyType;
    @Nullable String id;
    @Nullable String version;
    @Nullable String body;
    @JsonProperty("bodyType")
    public void setBodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty("body")
    public void setBody(String body) {
      this.body = body;
    }
    @Override
    public DialobDocument.DocumentType getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getBody() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUpdateStoreEntity fromJson(Json json) {
    ImmutableUpdateStoreEntity.Builder builder = ImmutableUpdateStoreEntity.builder();
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.UpdateStoreEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateStoreEntity instance
   */
  public static ImmutableUpdateStoreEntity copyOf(DialobStore.UpdateStoreEntity instance) {
    if (instance instanceof ImmutableUpdateStoreEntity) {
      return (ImmutableUpdateStoreEntity) instance;
    }
    return ImmutableUpdateStoreEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateStoreEntity ImmutableUpdateStoreEntity}.
   * <pre>
   * ImmutableUpdateStoreEntity.builder()
   *    .bodyType(io.dialob.client.api.DialobDocument.DocumentType) // required {@link DialobStore.UpdateStoreEntity#getBodyType() bodyType}
   *    .id(String) // required {@link DialobStore.UpdateStoreEntity#getId() id}
   *    .version(String) // required {@link DialobStore.UpdateStoreEntity#getVersion() version}
   *    .body(String) // required {@link DialobStore.UpdateStoreEntity#getBody() body}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateStoreEntity builder
   */
  public static ImmutableUpdateStoreEntity.Builder builder() {
    return new ImmutableUpdateStoreEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateStoreEntity ImmutableUpdateStoreEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.UpdateStoreEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BODY_TYPE = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private static final long INIT_BIT_BODY = 0x8L;
    private long initBits = 0xfL;

    private @Nullable DialobDocument.DocumentType bodyType;
    private @Nullable String id;
    private @Nullable String version;
    private @Nullable String body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.UpdateStoreEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.UpdateStoreEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.StoreCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DialobStore.UpdateStoreEntity) {
        DialobStore.UpdateStoreEntity instance = (DialobStore.UpdateStoreEntity) object;
        body(instance.getBody());
        version(instance.getVersion());
        id(instance.getId());
      }
      if (object instanceof DialobStore.StoreCommand) {
        DialobStore.StoreCommand instance = (DialobStore.StoreCommand) object;
        bodyType(instance.getBodyType());
      }
    }

    /**
     * Initializes the value for the {@link DialobStore.UpdateStoreEntity#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.UpdateStoreEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.UpdateStoreEntity#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.UpdateStoreEntity#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateStoreEntity ImmutableUpdateStoreEntity}.
     * @return An immutable instance of UpdateStoreEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateStoreEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateStoreEntity(bodyType, id, version, body);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      return "Cannot build UpdateStoreEntity, some of required attributes are not set " + attributes;
    }
  }
}
