package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.StoreExceptionMsg}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStoreExceptionMsg.builder()}.
 */
@Generated(from = "DialobStore.StoreExceptionMsg", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStoreExceptionMsg implements DialobStore.StoreExceptionMsg {
  private final String id;
  private final String value;
  private final ImmutableList<String> args;

  private ImmutableStoreExceptionMsg(
      String id,
      String value,
      ImmutableList<String> args) {
    this.id = id;
    this.value = value;
    this.args = args;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @JsonProperty("args")
  @Override
  public ImmutableList<String> getArgs() {
    return args;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.StoreExceptionMsg#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoreExceptionMsg withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableStoreExceptionMsg(newValue, this.value, this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.StoreExceptionMsg#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoreExceptionMsg withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableStoreExceptionMsg(this.id, newValue, this.args);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobStore.StoreExceptionMsg#getArgs() args}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStoreExceptionMsg withArgs(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStoreExceptionMsg(this.id, this.value, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobStore.StoreExceptionMsg#getArgs() args}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of args elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStoreExceptionMsg withArgs(Iterable<String> elements) {
    if (this.args == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStoreExceptionMsg(this.id, this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStoreExceptionMsg} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStoreExceptionMsg
        && equalTo((ImmutableStoreExceptionMsg) another);
  }

  private boolean equalTo(ImmutableStoreExceptionMsg another) {
    return id.equals(another.id)
        && value.equals(another.value)
        && args.equals(another.args);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}, {@code args}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + args.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StoreExceptionMsg} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StoreExceptionMsg")
        .omitNullValues()
        .add("id", id)
        .add("value", value)
        .add("args", args)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.StoreExceptionMsg", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.StoreExceptionMsg {
    @Nullable String id;
    @Nullable String value;
    @Nullable List<String> args = ImmutableList.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("args")
    public void setArgs(List<String> args) {
      this.args = args;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArgs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStoreExceptionMsg fromJson(Json json) {
    ImmutableStoreExceptionMsg.Builder builder = ImmutableStoreExceptionMsg.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.args != null) {
      builder.addAllArgs(json.args);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.StoreExceptionMsg} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StoreExceptionMsg instance
   */
  public static ImmutableStoreExceptionMsg copyOf(DialobStore.StoreExceptionMsg instance) {
    if (instance instanceof ImmutableStoreExceptionMsg) {
      return (ImmutableStoreExceptionMsg) instance;
    }
    return ImmutableStoreExceptionMsg.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStoreExceptionMsg ImmutableStoreExceptionMsg}.
   * <pre>
   * ImmutableStoreExceptionMsg.builder()
   *    .id(String) // required {@link DialobStore.StoreExceptionMsg#getId() id}
   *    .value(String) // required {@link DialobStore.StoreExceptionMsg#getValue() value}
   *    .addArgs|addAllArgs(String) // {@link DialobStore.StoreExceptionMsg#getArgs() args} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStoreExceptionMsg builder
   */
  public static ImmutableStoreExceptionMsg.Builder builder() {
    return new ImmutableStoreExceptionMsg.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStoreExceptionMsg ImmutableStoreExceptionMsg}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.StoreExceptionMsg", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String value;
    private ImmutableList.Builder<String> args = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StoreExceptionMsg} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreExceptionMsg instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      value(instance.getValue());
      addAllArgs(instance.getArgs());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.StoreExceptionMsg#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.StoreExceptionMsg#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link DialobStore.StoreExceptionMsg#getArgs() args} list.
     * @param element A args element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgs(String element) {
      this.args.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobStore.StoreExceptionMsg#getArgs() args} list.
     * @param elements An array of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArgs(String... elements) {
      this.args.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobStore.StoreExceptionMsg#getArgs() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder args(Iterable<String> elements) {
      this.args = ImmutableList.builder();
      return addAllArgs(elements);
    }

    /**
     * Adds elements to {@link DialobStore.StoreExceptionMsg#getArgs() args} list.
     * @param elements An iterable of args elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArgs(Iterable<String> elements) {
      this.args.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStoreExceptionMsg ImmutableStoreExceptionMsg}.
     * @return An immutable instance of StoreExceptionMsg
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStoreExceptionMsg build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStoreExceptionMsg(id, value, args.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build StoreExceptionMsg, some of required attributes are not set " + attributes;
    }
  }
}
