package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobClient.RevisionWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRevisionWrapper.builder()}.
 */
@Generated(from = "DialobClient.RevisionWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRevisionWrapper implements DialobClient.RevisionWrapper {
  private final DialobStore.StoreEntity source;
  private final DialobDocument.FormRevisionDocument document;

  private ImmutableRevisionWrapper(
      DialobStore.StoreEntity source,
      DialobDocument.FormRevisionDocument document) {
    this.source = source;
    this.document = document;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public DialobStore.StoreEntity getSource() {
    return source;
  }

  /**
   * @return The value of the {@code document} attribute
   */
  @Override
  public DialobDocument.FormRevisionDocument getDocument() {
    return document;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.RevisionWrapper#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRevisionWrapper withSource(DialobStore.StoreEntity value) {
    if (this.source == value) return this;
    DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
    return new ImmutableRevisionWrapper(newValue, this.document);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.RevisionWrapper#getDocument() document} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for document
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRevisionWrapper withDocument(DialobDocument.FormRevisionDocument value) {
    if (this.document == value) return this;
    DialobDocument.FormRevisionDocument newValue = Objects.requireNonNull(value, "document");
    return new ImmutableRevisionWrapper(this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRevisionWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRevisionWrapper
        && equalTo((ImmutableRevisionWrapper) another);
  }

  private boolean equalTo(ImmutableRevisionWrapper another) {
    return source.equals(another.source)
        && document.equals(another.document);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code document}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + document.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RevisionWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RevisionWrapper")
        .omitNullValues()
        .add("source", source)
        .add("document", document)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobClient.RevisionWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RevisionWrapper instance
   */
  public static ImmutableRevisionWrapper copyOf(DialobClient.RevisionWrapper instance) {
    if (instance instanceof ImmutableRevisionWrapper) {
      return (ImmutableRevisionWrapper) instance;
    }
    return ImmutableRevisionWrapper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRevisionWrapper ImmutableRevisionWrapper}.
   * <pre>
   * ImmutableRevisionWrapper.builder()
   *    .source(io.dialob.client.api.DialobStore.StoreEntity) // required {@link DialobClient.RevisionWrapper#getSource() source}
   *    .document(io.dialob.client.api.DialobDocument.FormRevisionDocument) // required {@link DialobClient.RevisionWrapper#getDocument() document}
   *    .build();
   * </pre>
   * @return A new ImmutableRevisionWrapper builder
   */
  public static ImmutableRevisionWrapper.Builder builder() {
    return new ImmutableRevisionWrapper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRevisionWrapper ImmutableRevisionWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobClient.RevisionWrapper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DOCUMENT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable DialobStore.StoreEntity source;
    private @Nullable DialobDocument.FormRevisionDocument document;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RevisionWrapper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobClient.RevisionWrapper instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.getSource());
      document(instance.getDocument());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.RevisionWrapper#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder source(DialobStore.StoreEntity source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.RevisionWrapper#getDocument() document} attribute.
     * @param document The value for document 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder document(DialobDocument.FormRevisionDocument document) {
      this.document = Objects.requireNonNull(document, "document");
      initBits &= ~INIT_BIT_DOCUMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRevisionWrapper ImmutableRevisionWrapper}.
     * @return An immutable instance of RevisionWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRevisionWrapper build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRevisionWrapper(source, document);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DOCUMENT) != 0) attributes.add("document");
      return "Cannot build RevisionWrapper, some of required attributes are not set " + attributes;
    }
  }
}
