package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobClient.ReleaseWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReleaseWrapper.builder()}.
 */
@Generated(from = "DialobClient.ReleaseWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReleaseWrapper implements DialobClient.ReleaseWrapper {
  private final DialobStore.StoreEntity source;
  private final DialobDocument.FormReleaseDocument document;

  private ImmutableReleaseWrapper(
      DialobStore.StoreEntity source,
      DialobDocument.FormReleaseDocument document) {
    this.source = source;
    this.document = document;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public DialobStore.StoreEntity getSource() {
    return source;
  }

  /**
   * @return The value of the {@code document} attribute
   */
  @Override
  public DialobDocument.FormReleaseDocument getDocument() {
    return document;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ReleaseWrapper#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReleaseWrapper withSource(DialobStore.StoreEntity value) {
    if (this.source == value) return this;
    DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
    return new ImmutableReleaseWrapper(newValue, this.document);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ReleaseWrapper#getDocument() document} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for document
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReleaseWrapper withDocument(DialobDocument.FormReleaseDocument value) {
    if (this.document == value) return this;
    DialobDocument.FormReleaseDocument newValue = Objects.requireNonNull(value, "document");
    return new ImmutableReleaseWrapper(this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReleaseWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReleaseWrapper
        && equalTo((ImmutableReleaseWrapper) another);
  }

  private boolean equalTo(ImmutableReleaseWrapper another) {
    return source.equals(another.source)
        && document.equals(another.document);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code document}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + document.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ReleaseWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ReleaseWrapper")
        .omitNullValues()
        .add("source", source)
        .add("document", document)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobClient.ReleaseWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReleaseWrapper instance
   */
  public static ImmutableReleaseWrapper copyOf(DialobClient.ReleaseWrapper instance) {
    if (instance instanceof ImmutableReleaseWrapper) {
      return (ImmutableReleaseWrapper) instance;
    }
    return ImmutableReleaseWrapper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReleaseWrapper ImmutableReleaseWrapper}.
   * <pre>
   * ImmutableReleaseWrapper.builder()
   *    .source(io.dialob.client.api.DialobStore.StoreEntity) // required {@link DialobClient.ReleaseWrapper#getSource() source}
   *    .document(io.dialob.client.api.DialobDocument.FormReleaseDocument) // required {@link DialobClient.ReleaseWrapper#getDocument() document}
   *    .build();
   * </pre>
   * @return A new ImmutableReleaseWrapper builder
   */
  public static ImmutableReleaseWrapper.Builder builder() {
    return new ImmutableReleaseWrapper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReleaseWrapper ImmutableReleaseWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobClient.ReleaseWrapper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DOCUMENT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable DialobStore.StoreEntity source;
    private @Nullable DialobDocument.FormReleaseDocument document;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReleaseWrapper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobClient.ReleaseWrapper instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.getSource());
      document(instance.getDocument());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ReleaseWrapper#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder source(DialobStore.StoreEntity source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ReleaseWrapper#getDocument() document} attribute.
     * @param document The value for document 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder document(DialobDocument.FormReleaseDocument document) {
      this.document = Objects.requireNonNull(document, "document");
      initBits &= ~INIT_BIT_DOCUMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReleaseWrapper ImmutableReleaseWrapper}.
     * @return An immutable instance of ReleaseWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReleaseWrapper build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableReleaseWrapper(source, document);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DOCUMENT) != 0) attributes.add("document");
      return "Cannot build ReleaseWrapper, some of required attributes are not set " + attributes;
    }
  }
}
