package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.FormValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobClient.ProgramMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProgramMessage.builder()}.
 */
@Generated(from = "DialobClient.ProgramMessage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProgramMessage implements DialobClient.ProgramMessage {
  private final String id;
  private final @Nullable String msg;
  private final @Nullable FormValidationError src;
  private final @Nullable Exception exception;

  private ImmutableProgramMessage(
      String id,
      @Nullable String msg,
      @Nullable FormValidationError src,
      @Nullable Exception exception) {
    this.id = id;
    this.msg = msg;
    this.src = src;
    this.exception = exception;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code msg} attribute
   */
  @Override
  public @Nullable String getMsg() {
    return msg;
  }

  /**
   * @return The value of the {@code src} attribute
   */
  @Override
  public @Nullable FormValidationError getSrc() {
    return src;
  }

  /**
   * @return The value of the {@code exception} attribute
   */
  @Override
  public @Nullable Exception getException() {
    return exception;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramMessage#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramMessage withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableProgramMessage(newValue, this.msg, this.src, this.exception);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramMessage#getMsg() msg} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for msg (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramMessage withMsg(@Nullable String value) {
    if (Objects.equals(this.msg, value)) return this;
    return new ImmutableProgramMessage(this.id, value, this.src, this.exception);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramMessage#getSrc() src} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for src (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramMessage withSrc(@Nullable FormValidationError value) {
    if (this.src == value) return this;
    return new ImmutableProgramMessage(this.id, this.msg, value, this.exception);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramMessage#getException() exception} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exception (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramMessage withException(@Nullable Exception value) {
    if (this.exception == value) return this;
    return new ImmutableProgramMessage(this.id, this.msg, this.src, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProgramMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProgramMessage
        && equalTo((ImmutableProgramMessage) another);
  }

  private boolean equalTo(ImmutableProgramMessage another) {
    return id.equals(another.id)
        && Objects.equals(msg, another.msg)
        && Objects.equals(src, another.src)
        && Objects.equals(exception, another.exception);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code msg}, {@code src}, {@code exception}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(msg);
    h += (h << 5) + Objects.hashCode(src);
    h += (h << 5) + Objects.hashCode(exception);
    return h;
  }

  /**
   * Prints the immutable value {@code ProgramMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProgramMessage")
        .omitNullValues()
        .add("id", id)
        .add("msg", msg)
        .add("src", src)
        .add("exception", exception)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobClient.ProgramMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProgramMessage instance
   */
  public static ImmutableProgramMessage copyOf(DialobClient.ProgramMessage instance) {
    if (instance instanceof ImmutableProgramMessage) {
      return (ImmutableProgramMessage) instance;
    }
    return ImmutableProgramMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProgramMessage ImmutableProgramMessage}.
   * <pre>
   * ImmutableProgramMessage.builder()
   *    .id(String) // required {@link DialobClient.ProgramMessage#getId() id}
   *    .msg(String | null) // nullable {@link DialobClient.ProgramMessage#getMsg() msg}
   *    .src(io.dialob.api.form.FormValidationError | null) // nullable {@link DialobClient.ProgramMessage#getSrc() src}
   *    .exception(Exception | null) // nullable {@link DialobClient.ProgramMessage#getException() exception}
   *    .build();
   * </pre>
   * @return A new ImmutableProgramMessage builder
   */
  public static ImmutableProgramMessage.Builder builder() {
    return new ImmutableProgramMessage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProgramMessage ImmutableProgramMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobClient.ProgramMessage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String msg;
    private @Nullable FormValidationError src;
    private @Nullable Exception exception;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProgramMessage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobClient.ProgramMessage instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      @Nullable String msgValue = instance.getMsg();
      if (msgValue != null) {
        msg(msgValue);
      }
      @Nullable FormValidationError srcValue = instance.getSrc();
      if (srcValue != null) {
        src(srcValue);
      }
      @Nullable Exception exceptionValue = instance.getException();
      if (exceptionValue != null) {
        exception(exceptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramMessage#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramMessage#getMsg() msg} attribute.
     * @param msg The value for msg (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder msg(@Nullable String msg) {
      this.msg = msg;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramMessage#getSrc() src} attribute.
     * @param src The value for src (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder src(@Nullable FormValidationError src) {
      this.src = src;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramMessage#getException() exception} attribute.
     * @param exception The value for exception (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder exception(@Nullable Exception exception) {
      this.exception = exception;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProgramMessage ImmutableProgramMessage}.
     * @return An immutable instance of ProgramMessage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProgramMessage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProgramMessage(id, msg, src, exception);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build ProgramMessage, some of required attributes are not set " + attributes;
    }
  }
}
