package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobDocument.FormRevisionEntryDocument}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormRevisionEntryDocument.builder()}.
 */
@Generated(from = "DialobDocument.FormRevisionEntryDocument", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormRevisionEntryDocument
    implements DialobDocument.FormRevisionEntryDocument {
  private final @Nullable String id;
  private final String revisionName;
  private final String formId;
  private final LocalDateTime created;
  private final LocalDateTime updated;
  private final @Nullable String description;

  private ImmutableFormRevisionEntryDocument(
      @Nullable String id,
      String revisionName,
      String formId,
      LocalDateTime created,
      LocalDateTime updated,
      @Nullable String description) {
    this.id = id;
    this.revisionName = revisionName;
    this.formId = formId;
    this.created = created;
    this.updated = updated;
    this.description = description;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code revisionName} attribute
   */
  @JsonProperty("revisionName")
  @Override
  public String getRevisionName() {
    return revisionName;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code updated} attribute
   */
  @JsonProperty("updated")
  @Override
  public LocalDateTime getUpdated() {
    return updated;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionEntryDocument#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionEntryDocument withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormRevisionEntryDocument(value, this.revisionName, this.formId, this.created, this.updated, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionEntryDocument#getRevisionName() revisionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revisionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionEntryDocument withRevisionName(String value) {
    String newValue = Objects.requireNonNull(value, "revisionName");
    if (this.revisionName.equals(newValue)) return this;
    return new ImmutableFormRevisionEntryDocument(this.id, newValue, this.formId, this.created, this.updated, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionEntryDocument#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionEntryDocument withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, newValue, this.created, this.updated, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionEntryDocument#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionEntryDocument withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, newValue, this.updated, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionEntryDocument#getUpdated() updated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionEntryDocument withUpdated(LocalDateTime value) {
    if (this.updated == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "updated");
    return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, this.created, newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionEntryDocument#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionEntryDocument withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFormRevisionEntryDocument(this.id, this.revisionName, this.formId, this.created, this.updated, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormRevisionEntryDocument} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormRevisionEntryDocument
        && equalTo((ImmutableFormRevisionEntryDocument) another);
  }

  private boolean equalTo(ImmutableFormRevisionEntryDocument another) {
    return Objects.equals(id, another.id)
        && revisionName.equals(another.revisionName)
        && formId.equals(another.formId)
        && created.equals(another.created)
        && updated.equals(another.updated)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code revisionName}, {@code formId}, {@code created}, {@code updated}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + revisionName.hashCode();
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + updated.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code FormRevisionEntryDocument} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormRevisionEntryDocument")
        .omitNullValues()
        .add("id", id)
        .add("revisionName", revisionName)
        .add("formId", formId)
        .add("created", created)
        .add("updated", updated)
        .add("description", description)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobDocument.FormRevisionEntryDocument", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobDocument.FormRevisionEntryDocument {
    @Nullable String id;
    @Nullable String revisionName;
    @Nullable String formId;
    @Nullable LocalDateTime created;
    @Nullable LocalDateTime updated;
    @Nullable String description;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("revisionName")
    public void setRevisionName(String revisionName) {
      this.revisionName = revisionName;
    }
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("updated")
    public void setUpdated(LocalDateTime updated) {
      this.updated = updated;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevisionName() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getUpdated() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormRevisionEntryDocument fromJson(Json json) {
    ImmutableFormRevisionEntryDocument.Builder builder = ImmutableFormRevisionEntryDocument.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.revisionName != null) {
      builder.revisionName(json.revisionName);
    }
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.updated != null) {
      builder.updated(json.updated);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobDocument.FormRevisionEntryDocument} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormRevisionEntryDocument instance
   */
  public static ImmutableFormRevisionEntryDocument copyOf(DialobDocument.FormRevisionEntryDocument instance) {
    if (instance instanceof ImmutableFormRevisionEntryDocument) {
      return (ImmutableFormRevisionEntryDocument) instance;
    }
    return ImmutableFormRevisionEntryDocument.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormRevisionEntryDocument ImmutableFormRevisionEntryDocument}.
   * <pre>
   * ImmutableFormRevisionEntryDocument.builder()
   *    .id(String | null) // nullable {@link DialobDocument.FormRevisionEntryDocument#getId() id}
   *    .revisionName(String) // required {@link DialobDocument.FormRevisionEntryDocument#getRevisionName() revisionName}
   *    .formId(String) // required {@link DialobDocument.FormRevisionEntryDocument#getFormId() formId}
   *    .created(java.time.LocalDateTime) // required {@link DialobDocument.FormRevisionEntryDocument#getCreated() created}
   *    .updated(java.time.LocalDateTime) // required {@link DialobDocument.FormRevisionEntryDocument#getUpdated() updated}
   *    .description(String | null) // nullable {@link DialobDocument.FormRevisionEntryDocument#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableFormRevisionEntryDocument builder
   */
  public static ImmutableFormRevisionEntryDocument.Builder builder() {
    return new ImmutableFormRevisionEntryDocument.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormRevisionEntryDocument ImmutableFormRevisionEntryDocument}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobDocument.FormRevisionEntryDocument", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REVISION_NAME = 0x1L;
    private static final long INIT_BIT_FORM_ID = 0x2L;
    private static final long INIT_BIT_CREATED = 0x4L;
    private static final long INIT_BIT_UPDATED = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String revisionName;
    private @Nullable String formId;
    private @Nullable LocalDateTime created;
    private @Nullable LocalDateTime updated;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormRevisionEntryDocument} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument.FormRevisionEntryDocument instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      revisionName(instance.getRevisionName());
      formId(instance.getFormId());
      created(instance.getCreated());
      updated(instance.getUpdated());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionEntryDocument#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionEntryDocument#getRevisionName() revisionName} attribute.
     * @param revisionName The value for revisionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revisionName")
    public final Builder revisionName(String revisionName) {
      this.revisionName = Objects.requireNonNull(revisionName, "revisionName");
      initBits &= ~INIT_BIT_REVISION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionEntryDocument#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionEntryDocument#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionEntryDocument#getUpdated() updated} attribute.
     * @param updated The value for updated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("updated")
    public final Builder updated(LocalDateTime updated) {
      this.updated = Objects.requireNonNull(updated, "updated");
      initBits &= ~INIT_BIT_UPDATED;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionEntryDocument#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormRevisionEntryDocument ImmutableFormRevisionEntryDocument}.
     * @return An immutable instance of FormRevisionEntryDocument
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormRevisionEntryDocument build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormRevisionEntryDocument(id, revisionName, formId, created, updated, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REVISION_NAME) != 0) attributes.add("revisionName");
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_UPDATED) != 0) attributes.add("updated");
      return "Cannot build FormRevisionEntryDocument, some of required attributes are not set " + attributes;
    }
  }
}
