package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.Form;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.FormCommands}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormCommands.builder()}.
 */
@Generated(from = "DialobComposer.FormCommands", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormCommands implements DialobComposer.FormCommands {
  private final Form form;
  private final ImmutableList<DialobComposer.FormCommand> values;

  private ImmutableFormCommands(
      Form form,
      ImmutableList<DialobComposer.FormCommand> values) {
    this.form = form;
    this.values = values;
  }

  /**
   * @return The value of the {@code form} attribute
   */
  @JsonProperty("form")
  @Override
  public Form getForm() {
    return form;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @JsonProperty("values")
  @Override
  public ImmutableList<DialobComposer.FormCommand> getValues() {
    return values;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.FormCommands#getForm() form} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for form
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormCommands withForm(Form value) {
    if (this.form == value) return this;
    Form newValue = Objects.requireNonNull(value, "form");
    return new ImmutableFormCommands(newValue, this.values);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.FormCommands#getValues() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormCommands withValues(DialobComposer.FormCommand... elements) {
    ImmutableList<DialobComposer.FormCommand> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormCommands(this.form, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.FormCommands#getValues() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormCommands withValues(Iterable<? extends DialobComposer.FormCommand> elements) {
    if (this.values == elements) return this;
    ImmutableList<DialobComposer.FormCommand> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormCommands(this.form, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormCommands} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormCommands
        && equalTo((ImmutableFormCommands) another);
  }

  private boolean equalTo(ImmutableFormCommands another) {
    return form.equals(another.form)
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code form}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + form.hashCode();
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormCommands} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormCommands")
        .omitNullValues()
        .add("form", form)
        .add("values", values)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.FormCommands", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.FormCommands {
    @Nullable Form form;
    @Nullable List<DialobComposer.FormCommand> values = ImmutableList.of();
    @JsonProperty("form")
    public void setForm(Form form) {
      this.form = form;
    }
    @JsonProperty("values")
    public void setValues(List<DialobComposer.FormCommand> values) {
      this.values = values;
    }
    @Override
    public Form getForm() { throw new UnsupportedOperationException(); }
    @Override
    public List<DialobComposer.FormCommand> getValues() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormCommands fromJson(Json json) {
    ImmutableFormCommands.Builder builder = ImmutableFormCommands.builder();
    if (json.form != null) {
      builder.form(json.form);
    }
    if (json.values != null) {
      builder.addAllValues(json.values);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.FormCommands} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormCommands instance
   */
  public static ImmutableFormCommands copyOf(DialobComposer.FormCommands instance) {
    if (instance instanceof ImmutableFormCommands) {
      return (ImmutableFormCommands) instance;
    }
    return ImmutableFormCommands.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormCommands ImmutableFormCommands}.
   * <pre>
   * ImmutableFormCommands.builder()
   *    .form(io.dialob.api.form.Form) // required {@link DialobComposer.FormCommands#getForm() form}
   *    .addValues|addAllValues(io.dialob.client.api.DialobComposer.FormCommand) // {@link DialobComposer.FormCommands#getValues() values} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFormCommands builder
   */
  public static ImmutableFormCommands.Builder builder() {
    return new ImmutableFormCommands.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormCommands ImmutableFormCommands}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.FormCommands", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Form form;
    private ImmutableList.Builder<DialobComposer.FormCommand> values = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormCommands} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.FormCommands instance) {
      Objects.requireNonNull(instance, "instance");
      form(instance.getForm());
      addAllValues(instance.getValues());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.FormCommands#getForm() form} attribute.
     * @param form The value for form 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("form")
    public final Builder form(Form form) {
      this.form = Objects.requireNonNull(form, "form");
      initBits &= ~INIT_BIT_FORM;
      return this;
    }

    /**
     * Adds one element to {@link DialobComposer.FormCommands#getValues() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(DialobComposer.FormCommand element) {
      this.values.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobComposer.FormCommands#getValues() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(DialobComposer.FormCommand... elements) {
      this.values.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobComposer.FormCommands#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("values")
    public final Builder values(Iterable<? extends DialobComposer.FormCommand> elements) {
      this.values = ImmutableList.builder();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link DialobComposer.FormCommands#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValues(Iterable<? extends DialobComposer.FormCommand> elements) {
      this.values.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormCommands ImmutableFormCommands}.
     * @return An immutable instance of FormCommands
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormCommands build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormCommands(form, values.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM) != 0) attributes.add("form");
      return "Cannot build FormCommands, some of required attributes are not set " + attributes;
    }
  }
}
