package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.proto.Actions;
import io.dialob.api.questionnaire.Questionnaire;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobClient.ExecutorBody}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecutorBody.builder()}.
 */
@Generated(from = "DialobClient.ExecutorBody", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableExecutorBody implements DialobClient.ExecutorBody {
  private final Actions actions;
  private final Questionnaire questionnaire;

  private ImmutableExecutorBody(Actions actions, Questionnaire questionnaire) {
    this.actions = actions;
    this.questionnaire = questionnaire;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @Override
  public Actions getActions() {
    return actions;
  }

  /**
   * @return The value of the {@code questionnaire} attribute
   */
  @Override
  public Questionnaire getQuestionnaire() {
    return questionnaire;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ExecutorBody#getActions() actions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for actions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutorBody withActions(Actions value) {
    if (this.actions == value) return this;
    Actions newValue = Objects.requireNonNull(value, "actions");
    return new ImmutableExecutorBody(newValue, this.questionnaire);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ExecutorBody#getQuestionnaire() questionnaire} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaire
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutorBody withQuestionnaire(Questionnaire value) {
    if (this.questionnaire == value) return this;
    Questionnaire newValue = Objects.requireNonNull(value, "questionnaire");
    return new ImmutableExecutorBody(this.actions, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecutorBody} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecutorBody
        && equalTo((ImmutableExecutorBody) another);
  }

  private boolean equalTo(ImmutableExecutorBody another) {
    return actions.equals(another.actions)
        && questionnaire.equals(another.questionnaire);
  }

  /**
   * Computes a hash code from attributes: {@code actions}, {@code questionnaire}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + actions.hashCode();
    h += (h << 5) + questionnaire.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExecutorBody} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ExecutorBody")
        .omitNullValues()
        .add("actions", actions)
        .add("questionnaire", questionnaire)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobClient.ExecutorBody} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecutorBody instance
   */
  public static ImmutableExecutorBody copyOf(DialobClient.ExecutorBody instance) {
    if (instance instanceof ImmutableExecutorBody) {
      return (ImmutableExecutorBody) instance;
    }
    return ImmutableExecutorBody.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecutorBody ImmutableExecutorBody}.
   * <pre>
   * ImmutableExecutorBody.builder()
   *    .actions(io.dialob.api.proto.Actions) // required {@link DialobClient.ExecutorBody#getActions() actions}
   *    .questionnaire(io.dialob.api.questionnaire.Questionnaire) // required {@link DialobClient.ExecutorBody#getQuestionnaire() questionnaire}
   *    .build();
   * </pre>
   * @return A new ImmutableExecutorBody builder
   */
  public static ImmutableExecutorBody.Builder builder() {
    return new ImmutableExecutorBody.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecutorBody ImmutableExecutorBody}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobClient.ExecutorBody", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACTIONS = 0x1L;
    private static final long INIT_BIT_QUESTIONNAIRE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Actions actions;
    private @Nullable Questionnaire questionnaire;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExecutorBody} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobClient.ExecutorBody instance) {
      Objects.requireNonNull(instance, "instance");
      actions(instance.getActions());
      questionnaire(instance.getQuestionnaire());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ExecutorBody#getActions() actions} attribute.
     * @param actions The value for actions 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder actions(Actions actions) {
      this.actions = Objects.requireNonNull(actions, "actions");
      initBits &= ~INIT_BIT_ACTIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ExecutorBody#getQuestionnaire() questionnaire} attribute.
     * @param questionnaire The value for questionnaire 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionnaire(Questionnaire questionnaire) {
      this.questionnaire = Objects.requireNonNull(questionnaire, "questionnaire");
      initBits &= ~INIT_BIT_QUESTIONNAIRE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecutorBody ImmutableExecutorBody}.
     * @return An immutable instance of ExecutorBody
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecutorBody build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecutorBody(actions, questionnaire);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACTIONS) != 0) attributes.add("actions");
      if ((initBits & INIT_BIT_QUESTIONNAIRE) != 0) attributes.add("questionnaire");
      return "Cannot build ExecutorBody, some of required attributes are not set " + attributes;
    }
  }
}
