package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.client.spi.event.QuestionnaireEventPublisher;
import io.dialob.client.spi.function.AsyncFunctionInvoker;
import io.dialob.compiler.DialobProgramFromFormCompiler;
import io.dialob.program.DialobSessionEvalContextFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobClientConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDialobClientConfig.builder()}.
 */
@Generated(from = "DialobClientConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDialobClientConfig implements DialobClientConfig {
  private final DialobStore store;
  private final DialobCache cache;
  private final DialobSessionEvalContextFactory factory;
  private final AsyncFunctionInvoker asyncFunctionInvoker;
  private final QuestionnaireEventPublisher eventPublisher;
  private final DialobClient.TypesMapper mapper;
  private final DialobProgramFromFormCompiler compiler;
  private final DialobErrorHandler errorHandler;

  private ImmutableDialobClientConfig(
      DialobStore store,
      DialobCache cache,
      DialobSessionEvalContextFactory factory,
      AsyncFunctionInvoker asyncFunctionInvoker,
      QuestionnaireEventPublisher eventPublisher,
      DialobClient.TypesMapper mapper,
      DialobProgramFromFormCompiler compiler,
      DialobErrorHandler errorHandler) {
    this.store = store;
    this.cache = cache;
    this.factory = factory;
    this.asyncFunctionInvoker = asyncFunctionInvoker;
    this.eventPublisher = eventPublisher;
    this.mapper = mapper;
    this.compiler = compiler;
    this.errorHandler = errorHandler;
  }

  /**
   * @return The value of the {@code store} attribute
   */
  @Override
  public DialobStore getStore() {
    return store;
  }

  /**
   * @return The value of the {@code cache} attribute
   */
  @Override
  public DialobCache getCache() {
    return cache;
  }

  /**
   * @return The value of the {@code factory} attribute
   */
  @Override
  public DialobSessionEvalContextFactory getFactory() {
    return factory;
  }

  /**
   * @return The value of the {@code asyncFunctionInvoker} attribute
   */
  @Override
  public AsyncFunctionInvoker getAsyncFunctionInvoker() {
    return asyncFunctionInvoker;
  }

  /**
   * @return The value of the {@code eventPublisher} attribute
   */
  @Override
  public QuestionnaireEventPublisher getEventPublisher() {
    return eventPublisher;
  }

  /**
   * @return The value of the {@code mapper} attribute
   */
  @Override
  public DialobClient.TypesMapper getMapper() {
    return mapper;
  }

  /**
   * @return The value of the {@code compiler} attribute
   */
  @Override
  public DialobProgramFromFormCompiler getCompiler() {
    return compiler;
  }

  /**
   * @return The value of the {@code errorHandler} attribute
   */
  @Override
  public DialobErrorHandler getErrorHandler() {
    return errorHandler;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getStore() store} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for store
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withStore(DialobStore value) {
    if (this.store == value) return this;
    DialobStore newValue = Objects.requireNonNull(value, "store");
    return new ImmutableDialobClientConfig(
        newValue,
        this.cache,
        this.factory,
        this.asyncFunctionInvoker,
        this.eventPublisher,
        this.mapper,
        this.compiler,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getCache() cache} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cache
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withCache(DialobCache value) {
    if (this.cache == value) return this;
    DialobCache newValue = Objects.requireNonNull(value, "cache");
    return new ImmutableDialobClientConfig(
        this.store,
        newValue,
        this.factory,
        this.asyncFunctionInvoker,
        this.eventPublisher,
        this.mapper,
        this.compiler,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getFactory() factory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for factory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withFactory(DialobSessionEvalContextFactory value) {
    if (this.factory == value) return this;
    DialobSessionEvalContextFactory newValue = Objects.requireNonNull(value, "factory");
    return new ImmutableDialobClientConfig(
        this.store,
        this.cache,
        newValue,
        this.asyncFunctionInvoker,
        this.eventPublisher,
        this.mapper,
        this.compiler,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getAsyncFunctionInvoker() asyncFunctionInvoker} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for asyncFunctionInvoker
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withAsyncFunctionInvoker(AsyncFunctionInvoker value) {
    if (this.asyncFunctionInvoker == value) return this;
    AsyncFunctionInvoker newValue = Objects.requireNonNull(value, "asyncFunctionInvoker");
    return new ImmutableDialobClientConfig(
        this.store,
        this.cache,
        this.factory,
        newValue,
        this.eventPublisher,
        this.mapper,
        this.compiler,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getEventPublisher() eventPublisher} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventPublisher
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withEventPublisher(QuestionnaireEventPublisher value) {
    if (this.eventPublisher == value) return this;
    QuestionnaireEventPublisher newValue = Objects.requireNonNull(value, "eventPublisher");
    return new ImmutableDialobClientConfig(
        this.store,
        this.cache,
        this.factory,
        this.asyncFunctionInvoker,
        newValue,
        this.mapper,
        this.compiler,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getMapper() mapper} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mapper
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withMapper(DialobClient.TypesMapper value) {
    if (this.mapper == value) return this;
    DialobClient.TypesMapper newValue = Objects.requireNonNull(value, "mapper");
    return new ImmutableDialobClientConfig(
        this.store,
        this.cache,
        this.factory,
        this.asyncFunctionInvoker,
        this.eventPublisher,
        newValue,
        this.compiler,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getCompiler() compiler} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for compiler
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withCompiler(DialobProgramFromFormCompiler value) {
    if (this.compiler == value) return this;
    DialobProgramFromFormCompiler newValue = Objects.requireNonNull(value, "compiler");
    return new ImmutableDialobClientConfig(
        this.store,
        this.cache,
        this.factory,
        this.asyncFunctionInvoker,
        this.eventPublisher,
        this.mapper,
        newValue,
        this.errorHandler);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClientConfig#getErrorHandler() errorHandler} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorHandler
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobClientConfig withErrorHandler(DialobErrorHandler value) {
    if (this.errorHandler == value) return this;
    DialobErrorHandler newValue = Objects.requireNonNull(value, "errorHandler");
    return new ImmutableDialobClientConfig(
        this.store,
        this.cache,
        this.factory,
        this.asyncFunctionInvoker,
        this.eventPublisher,
        this.mapper,
        this.compiler,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDialobClientConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDialobClientConfig
        && equalTo((ImmutableDialobClientConfig) another);
  }

  private boolean equalTo(ImmutableDialobClientConfig another) {
    return store.equals(another.store)
        && cache.equals(another.cache)
        && factory.equals(another.factory)
        && asyncFunctionInvoker.equals(another.asyncFunctionInvoker)
        && eventPublisher.equals(another.eventPublisher)
        && mapper.equals(another.mapper)
        && compiler.equals(another.compiler)
        && errorHandler.equals(another.errorHandler);
  }

  /**
   * Computes a hash code from attributes: {@code store}, {@code cache}, {@code factory}, {@code asyncFunctionInvoker}, {@code eventPublisher}, {@code mapper}, {@code compiler}, {@code errorHandler}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + store.hashCode();
    h += (h << 5) + cache.hashCode();
    h += (h << 5) + factory.hashCode();
    h += (h << 5) + asyncFunctionInvoker.hashCode();
    h += (h << 5) + eventPublisher.hashCode();
    h += (h << 5) + mapper.hashCode();
    h += (h << 5) + compiler.hashCode();
    h += (h << 5) + errorHandler.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DialobClientConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DialobClientConfig")
        .omitNullValues()
        .add("store", store)
        .add("cache", cache)
        .add("factory", factory)
        .add("asyncFunctionInvoker", asyncFunctionInvoker)
        .add("eventPublisher", eventPublisher)
        .add("mapper", mapper)
        .add("compiler", compiler)
        .add("errorHandler", errorHandler)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobClientConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DialobClientConfig instance
   */
  public static ImmutableDialobClientConfig copyOf(DialobClientConfig instance) {
    if (instance instanceof ImmutableDialobClientConfig) {
      return (ImmutableDialobClientConfig) instance;
    }
    return ImmutableDialobClientConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDialobClientConfig ImmutableDialobClientConfig}.
   * <pre>
   * ImmutableDialobClientConfig.builder()
   *    .store(io.dialob.client.api.DialobStore) // required {@link DialobClientConfig#getStore() store}
   *    .cache(io.dialob.client.api.DialobCache) // required {@link DialobClientConfig#getCache() cache}
   *    .factory(io.dialob.program.DialobSessionEvalContextFactory) // required {@link DialobClientConfig#getFactory() factory}
   *    .asyncFunctionInvoker(io.dialob.client.spi.function.AsyncFunctionInvoker) // required {@link DialobClientConfig#getAsyncFunctionInvoker() asyncFunctionInvoker}
   *    .eventPublisher(io.dialob.client.spi.event.QuestionnaireEventPublisher) // required {@link DialobClientConfig#getEventPublisher() eventPublisher}
   *    .mapper(io.dialob.client.api.DialobClient.TypesMapper) // required {@link DialobClientConfig#getMapper() mapper}
   *    .compiler(io.dialob.compiler.DialobProgramFromFormCompiler) // required {@link DialobClientConfig#getCompiler() compiler}
   *    .errorHandler(io.dialob.client.api.DialobErrorHandler) // required {@link DialobClientConfig#getErrorHandler() errorHandler}
   *    .build();
   * </pre>
   * @return A new ImmutableDialobClientConfig builder
   */
  public static ImmutableDialobClientConfig.Builder builder() {
    return new ImmutableDialobClientConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDialobClientConfig ImmutableDialobClientConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobClientConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STORE = 0x1L;
    private static final long INIT_BIT_CACHE = 0x2L;
    private static final long INIT_BIT_FACTORY = 0x4L;
    private static final long INIT_BIT_ASYNC_FUNCTION_INVOKER = 0x8L;
    private static final long INIT_BIT_EVENT_PUBLISHER = 0x10L;
    private static final long INIT_BIT_MAPPER = 0x20L;
    private static final long INIT_BIT_COMPILER = 0x40L;
    private static final long INIT_BIT_ERROR_HANDLER = 0x80L;
    private long initBits = 0xffL;

    private @Nullable DialobStore store;
    private @Nullable DialobCache cache;
    private @Nullable DialobSessionEvalContextFactory factory;
    private @Nullable AsyncFunctionInvoker asyncFunctionInvoker;
    private @Nullable QuestionnaireEventPublisher eventPublisher;
    private @Nullable DialobClient.TypesMapper mapper;
    private @Nullable DialobProgramFromFormCompiler compiler;
    private @Nullable DialobErrorHandler errorHandler;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DialobClientConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobClientConfig instance) {
      Objects.requireNonNull(instance, "instance");
      store(instance.getStore());
      cache(instance.getCache());
      factory(instance.getFactory());
      asyncFunctionInvoker(instance.getAsyncFunctionInvoker());
      eventPublisher(instance.getEventPublisher());
      mapper(instance.getMapper());
      compiler(instance.getCompiler());
      errorHandler(instance.getErrorHandler());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getStore() store} attribute.
     * @param store The value for store 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder store(DialobStore store) {
      this.store = Objects.requireNonNull(store, "store");
      initBits &= ~INIT_BIT_STORE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getCache() cache} attribute.
     * @param cache The value for cache 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cache(DialobCache cache) {
      this.cache = Objects.requireNonNull(cache, "cache");
      initBits &= ~INIT_BIT_CACHE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getFactory() factory} attribute.
     * @param factory The value for factory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder factory(DialobSessionEvalContextFactory factory) {
      this.factory = Objects.requireNonNull(factory, "factory");
      initBits &= ~INIT_BIT_FACTORY;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getAsyncFunctionInvoker() asyncFunctionInvoker} attribute.
     * @param asyncFunctionInvoker The value for asyncFunctionInvoker 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder asyncFunctionInvoker(AsyncFunctionInvoker asyncFunctionInvoker) {
      this.asyncFunctionInvoker = Objects.requireNonNull(asyncFunctionInvoker, "asyncFunctionInvoker");
      initBits &= ~INIT_BIT_ASYNC_FUNCTION_INVOKER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getEventPublisher() eventPublisher} attribute.
     * @param eventPublisher The value for eventPublisher 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder eventPublisher(QuestionnaireEventPublisher eventPublisher) {
      this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
      initBits &= ~INIT_BIT_EVENT_PUBLISHER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getMapper() mapper} attribute.
     * @param mapper The value for mapper 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mapper(DialobClient.TypesMapper mapper) {
      this.mapper = Objects.requireNonNull(mapper, "mapper");
      initBits &= ~INIT_BIT_MAPPER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getCompiler() compiler} attribute.
     * @param compiler The value for compiler 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder compiler(DialobProgramFromFormCompiler compiler) {
      this.compiler = Objects.requireNonNull(compiler, "compiler");
      initBits &= ~INIT_BIT_COMPILER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClientConfig#getErrorHandler() errorHandler} attribute.
     * @param errorHandler The value for errorHandler 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorHandler(DialobErrorHandler errorHandler) {
      this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
      initBits &= ~INIT_BIT_ERROR_HANDLER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDialobClientConfig ImmutableDialobClientConfig}.
     * @return An immutable instance of DialobClientConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDialobClientConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDialobClientConfig(store, cache, factory, asyncFunctionInvoker, eventPublisher, mapper, compiler, errorHandler);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STORE) != 0) attributes.add("store");
      if ((initBits & INIT_BIT_CACHE) != 0) attributes.add("cache");
      if ((initBits & INIT_BIT_FACTORY) != 0) attributes.add("factory");
      if ((initBits & INIT_BIT_ASYNC_FUNCTION_INVOKER) != 0) attributes.add("asyncFunctionInvoker");
      if ((initBits & INIT_BIT_EVENT_PUBLISHER) != 0) attributes.add("eventPublisher");
      if ((initBits & INIT_BIT_MAPPER) != 0) attributes.add("mapper");
      if ((initBits & INIT_BIT_COMPILER) != 0) attributes.add("compiler");
      if ((initBits & INIT_BIT_ERROR_HANDLER) != 0) attributes.add("errorHandler");
      return "Cannot build DialobClientConfig, some of required attributes are not set " + attributes;
    }
  }
}
