package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.DeleteStoreEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteStoreEntity.builder()}.
 */
@Generated(from = "DialobStore.DeleteStoreEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeleteStoreEntity implements DialobStore.DeleteStoreEntity {
  private final DialobDocument.DocumentType bodyType;
  private final String id;
  private final String version;

  private ImmutableDeleteStoreEntity(
      DialobDocument.DocumentType bodyType,
      String id,
      String version) {
    this.bodyType = bodyType;
    this.id = id;
    this.version = version;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public DialobDocument.DocumentType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.DeleteStoreEntity#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteStoreEntity withBodyType(DialobDocument.DocumentType value) {
    if (this.bodyType == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableDeleteStoreEntity(newValue, this.id, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.DeleteStoreEntity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteStoreEntity withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDeleteStoreEntity(this.bodyType, newValue, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.DeleteStoreEntity#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteStoreEntity withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableDeleteStoreEntity(this.bodyType, this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteStoreEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteStoreEntity
        && equalTo((ImmutableDeleteStoreEntity) another);
  }

  private boolean equalTo(ImmutableDeleteStoreEntity another) {
    return bodyType.equals(another.bodyType)
        && id.equals(another.id)
        && version.equals(another.version);
  }

  /**
   * Computes a hash code from attributes: {@code bodyType}, {@code id}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteStoreEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeleteStoreEntity")
        .omitNullValues()
        .add("bodyType", bodyType)
        .add("id", id)
        .add("version", version)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.DeleteStoreEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.DeleteStoreEntity {
    @Nullable DialobDocument.DocumentType bodyType;
    @Nullable String id;
    @Nullable String version;
    @JsonProperty("bodyType")
    public void setBodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(String version) {
      this.version = version;
    }
    @Override
    public DialobDocument.DocumentType getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeleteStoreEntity fromJson(Json json) {
    ImmutableDeleteStoreEntity.Builder builder = ImmutableDeleteStoreEntity.builder();
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.DeleteStoreEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteStoreEntity instance
   */
  public static ImmutableDeleteStoreEntity copyOf(DialobStore.DeleteStoreEntity instance) {
    if (instance instanceof ImmutableDeleteStoreEntity) {
      return (ImmutableDeleteStoreEntity) instance;
    }
    return ImmutableDeleteStoreEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteStoreEntity ImmutableDeleteStoreEntity}.
   * <pre>
   * ImmutableDeleteStoreEntity.builder()
   *    .bodyType(io.dialob.client.api.DialobDocument.DocumentType) // required {@link DialobStore.DeleteStoreEntity#getBodyType() bodyType}
   *    .id(String) // required {@link DialobStore.DeleteStoreEntity#getId() id}
   *    .version(String) // required {@link DialobStore.DeleteStoreEntity#getVersion() version}
   *    .build();
   * </pre>
   * @return A new ImmutableDeleteStoreEntity builder
   */
  public static ImmutableDeleteStoreEntity.Builder builder() {
    return new ImmutableDeleteStoreEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteStoreEntity ImmutableDeleteStoreEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.DeleteStoreEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BODY_TYPE = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private long initBits = 0x7L;

    private @Nullable DialobDocument.DocumentType bodyType;
    private @Nullable String id;
    private @Nullable String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.StoreCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.DeleteStoreEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.DeleteStoreEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DialobStore.StoreCommand) {
        DialobStore.StoreCommand instance = (DialobStore.StoreCommand) object;
        bodyType(instance.getBodyType());
      }
      if (object instanceof DialobStore.DeleteStoreEntity) {
        DialobStore.DeleteStoreEntity instance = (DialobStore.DeleteStoreEntity) object;
        version(instance.getVersion());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link DialobStore.DeleteStoreEntity#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.DeleteStoreEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.DeleteStoreEntity#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteStoreEntity ImmutableDeleteStoreEntity}.
     * @return An immutable instance of DeleteStoreEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteStoreEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDeleteStoreEntity(bodyType, id, version);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build DeleteStoreEntity, some of required attributes are not set " + attributes;
    }
  }
}
