package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.CreateStoreEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateStoreEntity.builder()}.
 */
@Generated(from = "DialobStore.CreateStoreEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateStoreEntity implements DialobStore.CreateStoreEntity {
  private final DialobDocument.DocumentType bodyType;
  private final @Nullable String id;
  private final @Nullable String version;
  private final String body;

  private ImmutableCreateStoreEntity(
      DialobDocument.DocumentType bodyType,
      @Nullable String id,
      @Nullable String version,
      String body) {
    this.bodyType = bodyType;
    this.id = id;
    this.version = version;
    this.body = body;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public DialobDocument.DocumentType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public String getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.CreateStoreEntity#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateStoreEntity withBodyType(DialobDocument.DocumentType value) {
    if (this.bodyType == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableCreateStoreEntity(newValue, this.id, this.version, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.CreateStoreEntity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateStoreEntity withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableCreateStoreEntity(this.bodyType, value, this.version, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.CreateStoreEntity#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateStoreEntity withVersion(@Nullable String value) {
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableCreateStoreEntity(this.bodyType, this.id, value, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.CreateStoreEntity#getBody() body} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateStoreEntity withBody(String value) {
    String newValue = Objects.requireNonNull(value, "body");
    if (this.body.equals(newValue)) return this;
    return new ImmutableCreateStoreEntity(this.bodyType, this.id, this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateStoreEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateStoreEntity
        && equalTo((ImmutableCreateStoreEntity) another);
  }

  private boolean equalTo(ImmutableCreateStoreEntity another) {
    return bodyType.equals(another.bodyType)
        && Objects.equals(id, another.id)
        && Objects.equals(version, another.version)
        && body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code bodyType}, {@code id}, {@code version}, {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateStoreEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateStoreEntity")
        .omitNullValues()
        .add("bodyType", bodyType)
        .add("id", id)
        .add("version", version)
        .add("body", body)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.CreateStoreEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.CreateStoreEntity {
    @Nullable DialobDocument.DocumentType bodyType;
    @Nullable String id;
    @Nullable String version;
    @Nullable String body;
    @JsonProperty("bodyType")
    public void setBodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @JsonProperty("body")
    public void setBody(String body) {
      this.body = body;
    }
    @Override
    public DialobDocument.DocumentType getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getBody() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateStoreEntity fromJson(Json json) {
    ImmutableCreateStoreEntity.Builder builder = ImmutableCreateStoreEntity.builder();
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.CreateStoreEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateStoreEntity instance
   */
  public static ImmutableCreateStoreEntity copyOf(DialobStore.CreateStoreEntity instance) {
    if (instance instanceof ImmutableCreateStoreEntity) {
      return (ImmutableCreateStoreEntity) instance;
    }
    return ImmutableCreateStoreEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateStoreEntity ImmutableCreateStoreEntity}.
   * <pre>
   * ImmutableCreateStoreEntity.builder()
   *    .bodyType(io.dialob.client.api.DialobDocument.DocumentType) // required {@link DialobStore.CreateStoreEntity#getBodyType() bodyType}
   *    .id(String | null) // nullable {@link DialobStore.CreateStoreEntity#getId() id}
   *    .version(String | null) // nullable {@link DialobStore.CreateStoreEntity#getVersion() version}
   *    .body(String) // required {@link DialobStore.CreateStoreEntity#getBody() body}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateStoreEntity builder
   */
  public static ImmutableCreateStoreEntity.Builder builder() {
    return new ImmutableCreateStoreEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateStoreEntity ImmutableCreateStoreEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.CreateStoreEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BODY_TYPE = 0x1L;
    private static final long INIT_BIT_BODY = 0x2L;
    private long initBits = 0x3L;

    private @Nullable DialobDocument.DocumentType bodyType;
    private @Nullable String id;
    private @Nullable String version;
    private @Nullable String body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.CreateStoreEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.CreateStoreEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.StoreCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DialobStore.CreateStoreEntity) {
        DialobStore.CreateStoreEntity instance = (DialobStore.CreateStoreEntity) object;
        body(instance.getBody());
        @Nullable String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
      }
      if (object instanceof DialobStore.StoreCommand) {
        DialobStore.StoreCommand instance = (DialobStore.StoreCommand) object;
        bodyType(instance.getBodyType());
      }
    }

    /**
     * Initializes the value for the {@link DialobStore.CreateStoreEntity#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.CreateStoreEntity#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.CreateStoreEntity#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.CreateStoreEntity#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateStoreEntity ImmutableCreateStoreEntity}.
     * @return An immutable instance of CreateStoreEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateStoreEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateStoreEntity(bodyType, id, version, body);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      return "Cannot build CreateStoreEntity, some of required attributes are not set " + attributes;
    }
  }
}
