package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.ComposerReleaseState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposerReleaseState.builder()}.
 */
@Generated(from = "DialobComposer.ComposerReleaseState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComposerReleaseState
    implements DialobComposer.ComposerReleaseState {
  private final String id;
  private final String name;
  private final String description;
  private final String hash;
  private final String content;

  private ImmutableComposerReleaseState(
      String id,
      String name,
      String description,
      String hash,
      String content) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.hash = hash;
    this.content = content;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerReleaseState#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerReleaseState withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableComposerReleaseState(newValue, this.name, this.description, this.hash, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerReleaseState#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerReleaseState withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableComposerReleaseState(this.id, newValue, this.description, this.hash, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerReleaseState#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerReleaseState withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableComposerReleaseState(this.id, this.name, newValue, this.hash, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerReleaseState#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerReleaseState withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableComposerReleaseState(this.id, this.name, this.description, newValue, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerReleaseState#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerReleaseState withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutableComposerReleaseState(this.id, this.name, this.description, this.hash, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposerReleaseState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposerReleaseState
        && equalTo((ImmutableComposerReleaseState) another);
  }

  private boolean equalTo(ImmutableComposerReleaseState another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && description.equals(another.description)
        && hash.equals(another.hash)
        && content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code hash}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposerReleaseState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ComposerReleaseState")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("description", description)
        .add("hash", hash)
        .add("content", content)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.ComposerReleaseState", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.ComposerReleaseState {
    @Nullable String id;
    @Nullable String name;
    @Nullable String description;
    @Nullable String hash;
    @Nullable String content;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComposerReleaseState fromJson(Json json) {
    ImmutableComposerReleaseState.Builder builder = ImmutableComposerReleaseState.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.ComposerReleaseState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComposerReleaseState instance
   */
  public static ImmutableComposerReleaseState copyOf(DialobComposer.ComposerReleaseState instance) {
    if (instance instanceof ImmutableComposerReleaseState) {
      return (ImmutableComposerReleaseState) instance;
    }
    return ImmutableComposerReleaseState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposerReleaseState ImmutableComposerReleaseState}.
   * <pre>
   * ImmutableComposerReleaseState.builder()
   *    .id(String) // required {@link DialobComposer.ComposerReleaseState#getId() id}
   *    .name(String) // required {@link DialobComposer.ComposerReleaseState#getName() name}
   *    .description(String) // required {@link DialobComposer.ComposerReleaseState#getDescription() description}
   *    .hash(String) // required {@link DialobComposer.ComposerReleaseState#getHash() hash}
   *    .content(String) // required {@link DialobComposer.ComposerReleaseState#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutableComposerReleaseState builder
   */
  public static ImmutableComposerReleaseState.Builder builder() {
    return new ImmutableComposerReleaseState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComposerReleaseState ImmutableComposerReleaseState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.ComposerReleaseState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private static final long INIT_BIT_HASH = 0x8L;
    private static final long INIT_BIT_CONTENT = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String hash;
    private @Nullable String content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposerReleaseState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.ComposerReleaseState instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      description(instance.getDescription());
      hash(instance.getHash());
      content(instance.getContent());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerReleaseState#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerReleaseState#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerReleaseState#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerReleaseState#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerReleaseState#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposerReleaseState ImmutableComposerReleaseState}.
     * @return An immutable instance of ComposerReleaseState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposerReleaseState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComposerReleaseState(id, name, description, hash, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build ComposerReleaseState, some of required attributes are not set " + attributes;
    }
  }
}
