package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.ComposerDocumentState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposerDocumentState.builder()}.
 */
@Generated(from = "DialobComposer.ComposerDocumentState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComposerDocumentState
    implements DialobComposer.ComposerDocumentState {
  private final DialobDocument.FormDocument form;
  private final DialobDocument.FormRevisionDocument revision;

  private ImmutableComposerDocumentState(
      DialobDocument.FormDocument form,
      DialobDocument.FormRevisionDocument revision) {
    this.form = form;
    this.revision = revision;
  }

  /**
   * @return The value of the {@code form} attribute
   */
  @JsonProperty("form")
  @Override
  public DialobDocument.FormDocument getForm() {
    return form;
  }

  /**
   * @return The value of the {@code revision} attribute
   */
  @JsonProperty("revision")
  @Override
  public DialobDocument.FormRevisionDocument getRevision() {
    return revision;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerDocumentState#getForm() form} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for form
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerDocumentState withForm(DialobDocument.FormDocument value) {
    if (this.form == value) return this;
    DialobDocument.FormDocument newValue = Objects.requireNonNull(value, "form");
    return new ImmutableComposerDocumentState(newValue, this.revision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerDocumentState#getRevision() revision} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerDocumentState withRevision(DialobDocument.FormRevisionDocument value) {
    if (this.revision == value) return this;
    DialobDocument.FormRevisionDocument newValue = Objects.requireNonNull(value, "revision");
    return new ImmutableComposerDocumentState(this.form, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposerDocumentState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposerDocumentState
        && equalTo((ImmutableComposerDocumentState) another);
  }

  private boolean equalTo(ImmutableComposerDocumentState another) {
    return form.equals(another.form)
        && revision.equals(another.revision);
  }

  /**
   * Computes a hash code from attributes: {@code form}, {@code revision}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + form.hashCode();
    h += (h << 5) + revision.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposerDocumentState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ComposerDocumentState")
        .omitNullValues()
        .add("form", form)
        .add("revision", revision)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.ComposerDocumentState", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.ComposerDocumentState {
    @Nullable DialobDocument.FormDocument form;
    @Nullable DialobDocument.FormRevisionDocument revision;
    @JsonProperty("form")
    public void setForm(DialobDocument.FormDocument form) {
      this.form = form;
    }
    @JsonProperty("revision")
    public void setRevision(DialobDocument.FormRevisionDocument revision) {
      this.revision = revision;
    }
    @Override
    public DialobDocument.FormDocument getForm() { throw new UnsupportedOperationException(); }
    @Override
    public DialobDocument.FormRevisionDocument getRevision() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComposerDocumentState fromJson(Json json) {
    ImmutableComposerDocumentState.Builder builder = ImmutableComposerDocumentState.builder();
    if (json.form != null) {
      builder.form(json.form);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.ComposerDocumentState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComposerDocumentState instance
   */
  public static ImmutableComposerDocumentState copyOf(DialobComposer.ComposerDocumentState instance) {
    if (instance instanceof ImmutableComposerDocumentState) {
      return (ImmutableComposerDocumentState) instance;
    }
    return ImmutableComposerDocumentState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposerDocumentState ImmutableComposerDocumentState}.
   * <pre>
   * ImmutableComposerDocumentState.builder()
   *    .form(io.dialob.client.api.DialobDocument.FormDocument) // required {@link DialobComposer.ComposerDocumentState#getForm() form}
   *    .revision(io.dialob.client.api.DialobDocument.FormRevisionDocument) // required {@link DialobComposer.ComposerDocumentState#getRevision() revision}
   *    .build();
   * </pre>
   * @return A new ImmutableComposerDocumentState builder
   */
  public static ImmutableComposerDocumentState.Builder builder() {
    return new ImmutableComposerDocumentState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComposerDocumentState ImmutableComposerDocumentState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.ComposerDocumentState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM = 0x1L;
    private static final long INIT_BIT_REVISION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable DialobDocument.FormDocument form;
    private @Nullable DialobDocument.FormRevisionDocument revision;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposerDocumentState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.ComposerDocumentState instance) {
      Objects.requireNonNull(instance, "instance");
      form(instance.getForm());
      revision(instance.getRevision());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerDocumentState#getForm() form} attribute.
     * @param form The value for form 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("form")
    public final Builder form(DialobDocument.FormDocument form) {
      this.form = Objects.requireNonNull(form, "form");
      initBits &= ~INIT_BIT_FORM;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerDocumentState#getRevision() revision} attribute.
     * @param revision The value for revision 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revision")
    public final Builder revision(DialobDocument.FormRevisionDocument revision) {
      this.revision = Objects.requireNonNull(revision, "revision");
      initBits &= ~INIT_BIT_REVISION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposerDocumentState ImmutableComposerDocumentState}.
     * @return An immutable instance of ComposerDocumentState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposerDocumentState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComposerDocumentState(form, revision);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM) != 0) attributes.add("form");
      if ((initBits & INIT_BIT_REVISION) != 0) attributes.add("revision");
      return "Cannot build ComposerDocumentState, some of required attributes are not set " + attributes;
    }
  }
}
