package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.program.DialobProgram;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobCache.CacheEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCacheEntry.builder()}.
 */
@Generated(from = "DialobCache.CacheEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCacheEntry implements DialobCache.CacheEntry {
  private final String id;
  private final String rev;
  private final DialobStore.StoreEntity source;
  private final DialobDocument ast;
  private final @Nullable DialobProgram program;

  private ImmutableCacheEntry(
      String id,
      String rev,
      DialobStore.StoreEntity source,
      DialobDocument ast,
      @Nullable DialobProgram program) {
    this.id = id;
    this.rev = rev;
    this.source = source;
    this.ast = ast;
    this.program = program;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public DialobStore.StoreEntity getSource() {
    return source;
  }

  /**
   * @return The value of the {@code ast} attribute
   */
  @Override
  public DialobDocument getAst() {
    return ast;
  }

  /**
   * @return The value of the {@code program} attribute
   */
  @Override
  public Optional<DialobProgram> getProgram() {
    return Optional.ofNullable(program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobCache.CacheEntry#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCacheEntry withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableCacheEntry(newValue, this.rev, this.source, this.ast, this.program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobCache.CacheEntry#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCacheEntry withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableCacheEntry(this.id, newValue, this.source, this.ast, this.program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobCache.CacheEntry#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCacheEntry withSource(DialobStore.StoreEntity value) {
    if (this.source == value) return this;
    DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
    return new ImmutableCacheEntry(this.id, this.rev, newValue, this.ast, this.program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobCache.CacheEntry#getAst() ast} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ast
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCacheEntry withAst(DialobDocument value) {
    if (this.ast == value) return this;
    DialobDocument newValue = Objects.requireNonNull(value, "ast");
    return new ImmutableCacheEntry(this.id, this.rev, this.source, newValue, this.program);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DialobCache.CacheEntry#getProgram() program} attribute.
   * @param value The value for program
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCacheEntry withProgram(DialobProgram value) {
    @Nullable DialobProgram newValue = Objects.requireNonNull(value, "program");
    if (this.program == newValue) return this;
    return new ImmutableCacheEntry(this.id, this.rev, this.source, this.ast, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DialobCache.CacheEntry#getProgram() program} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for program
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCacheEntry withProgram(Optional<? extends DialobProgram> optional) {
    @Nullable DialobProgram value = optional.orElse(null);
    if (this.program == value) return this;
    return new ImmutableCacheEntry(this.id, this.rev, this.source, this.ast, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCacheEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCacheEntry
        && equalTo((ImmutableCacheEntry) another);
  }

  private boolean equalTo(ImmutableCacheEntry another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && source.equals(another.source)
        && ast.equals(another.ast)
        && Objects.equals(program, another.program);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code source}, {@code ast}, {@code program}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + ast.hashCode();
    h += (h << 5) + Objects.hashCode(program);
    return h;
  }

  /**
   * Prints the immutable value {@code CacheEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CacheEntry")
        .omitNullValues()
        .add("id", id)
        .add("rev", rev)
        .add("source", source)
        .add("ast", ast)
        .add("program", program)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobCache.CacheEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CacheEntry instance
   */
  public static ImmutableCacheEntry copyOf(DialobCache.CacheEntry instance) {
    if (instance instanceof ImmutableCacheEntry) {
      return (ImmutableCacheEntry) instance;
    }
    return ImmutableCacheEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCacheEntry ImmutableCacheEntry}.
   * <pre>
   * ImmutableCacheEntry.builder()
   *    .id(String) // required {@link DialobCache.CacheEntry#getId() id}
   *    .rev(String) // required {@link DialobCache.CacheEntry#getRev() rev}
   *    .source(io.dialob.client.api.DialobStore.StoreEntity) // required {@link DialobCache.CacheEntry#getSource() source}
   *    .ast(io.dialob.client.api.DialobDocument) // required {@link DialobCache.CacheEntry#getAst() ast}
   *    .program(io.dialob.program.DialobProgram) // optional {@link DialobCache.CacheEntry#getProgram() program}
   *    .build();
   * </pre>
   * @return A new ImmutableCacheEntry builder
   */
  public static ImmutableCacheEntry.Builder builder() {
    return new ImmutableCacheEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCacheEntry ImmutableCacheEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobCache.CacheEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private static final long INIT_BIT_AST = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable DialobStore.StoreEntity source;
    private @Nullable DialobDocument ast;
    private @Nullable DialobProgram program;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CacheEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobCache.CacheEntry instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      source(instance.getSource());
      ast(instance.getAst());
      Optional<DialobProgram> programOptional = instance.getProgram();
      if (programOptional.isPresent()) {
        program(programOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DialobCache.CacheEntry#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobCache.CacheEntry#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobCache.CacheEntry#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder source(DialobStore.StoreEntity source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobCache.CacheEntry#getAst() ast} attribute.
     * @param ast The value for ast 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ast(DialobDocument ast) {
      this.ast = Objects.requireNonNull(ast, "ast");
      initBits &= ~INIT_BIT_AST;
      return this;
    }

    /**
     * Initializes the optional value {@link DialobCache.CacheEntry#getProgram() program} to program.
     * @param program The value for program
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder program(DialobProgram program) {
      this.program = Objects.requireNonNull(program, "program");
      return this;
    }

    /**
     * Initializes the optional value {@link DialobCache.CacheEntry#getProgram() program} to program.
     * @param program The value for program
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder program(Optional<? extends DialobProgram> program) {
      this.program = program.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCacheEntry ImmutableCacheEntry}.
     * @return An immutable instance of CacheEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCacheEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCacheEntry(id, rev, source, ast, program);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_AST) != 0) attributes.add("ast");
      return "Cannot build CacheEntry, some of required attributes are not set " + attributes;
    }
  }
}
