package io.dialob.client.spi.store;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.DocDB;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStoreConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDialobStoreConfig.builder()}.
 */
@Generated(from = "DialobStoreConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDialobStoreConfig implements DialobStoreConfig {
  private final DocDB client;
  private final String repoName;
  private final String headName;
  private final DialobStoreConfig.AuthorProvider authorProvider;
  private final DialobStoreConfig.GidProvider gidProvider;
  private final DialobStoreConfig.Serializer serializer;
  private final DialobStoreConfig.Deserializer deserializer;

  private ImmutableDialobStoreConfig(
      DocDB client,
      String repoName,
      String headName,
      DialobStoreConfig.AuthorProvider authorProvider,
      DialobStoreConfig.GidProvider gidProvider,
      DialobStoreConfig.Serializer serializer,
      DialobStoreConfig.Deserializer deserializer) {
    this.client = client;
    this.repoName = repoName;
    this.headName = headName;
    this.authorProvider = authorProvider;
    this.gidProvider = gidProvider;
    this.serializer = serializer;
    this.deserializer = deserializer;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public DocDB getClient() {
    return client;
  }

  /**
   * @return The value of the {@code repoName} attribute
   */
  @Override
  public String getRepoName() {
    return repoName;
  }

  /**
   * @return The value of the {@code headName} attribute
   */
  @Override
  public String getHeadName() {
    return headName;
  }

  /**
   * @return The value of the {@code authorProvider} attribute
   */
  @Override
  public DialobStoreConfig.AuthorProvider getAuthorProvider() {
    return authorProvider;
  }

  /**
   * @return The value of the {@code gidProvider} attribute
   */
  @Override
  public DialobStoreConfig.GidProvider getGidProvider() {
    return gidProvider;
  }

  /**
   * @return The value of the {@code serializer} attribute
   */
  @Override
  public DialobStoreConfig.Serializer getSerializer() {
    return serializer;
  }

  /**
   * @return The value of the {@code deserializer} attribute
   */
  @Override
  public DialobStoreConfig.Deserializer getDeserializer() {
    return deserializer;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withClient(DocDB value) {
    if (this.client == value) return this;
    DocDB newValue = Objects.requireNonNull(value, "client");
    return new ImmutableDialobStoreConfig(
        newValue,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.gidProvider,
        this.serializer,
        this.deserializer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getRepoName() repoName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repoName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withRepoName(String value) {
    String newValue = Objects.requireNonNull(value, "repoName");
    if (this.repoName.equals(newValue)) return this;
    return new ImmutableDialobStoreConfig(
        this.client,
        newValue,
        this.headName,
        this.authorProvider,
        this.gidProvider,
        this.serializer,
        this.deserializer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getHeadName() headName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withHeadName(String value) {
    String newValue = Objects.requireNonNull(value, "headName");
    if (this.headName.equals(newValue)) return this;
    return new ImmutableDialobStoreConfig(
        this.client,
        this.repoName,
        newValue,
        this.authorProvider,
        this.gidProvider,
        this.serializer,
        this.deserializer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getAuthorProvider() authorProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for authorProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withAuthorProvider(DialobStoreConfig.AuthorProvider value) {
    if (this.authorProvider == value) return this;
    DialobStoreConfig.AuthorProvider newValue = Objects.requireNonNull(value, "authorProvider");
    return new ImmutableDialobStoreConfig(
        this.client,
        this.repoName,
        this.headName,
        newValue,
        this.gidProvider,
        this.serializer,
        this.deserializer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getGidProvider() gidProvider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gidProvider
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withGidProvider(DialobStoreConfig.GidProvider value) {
    if (this.gidProvider == value) return this;
    DialobStoreConfig.GidProvider newValue = Objects.requireNonNull(value, "gidProvider");
    return new ImmutableDialobStoreConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        newValue,
        this.serializer,
        this.deserializer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getSerializer() serializer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serializer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withSerializer(DialobStoreConfig.Serializer value) {
    if (this.serializer == value) return this;
    DialobStoreConfig.Serializer newValue = Objects.requireNonNull(value, "serializer");
    return new ImmutableDialobStoreConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.gidProvider,
        newValue,
        this.deserializer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStoreConfig#getDeserializer() deserializer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deserializer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDialobStoreConfig withDeserializer(DialobStoreConfig.Deserializer value) {
    if (this.deserializer == value) return this;
    DialobStoreConfig.Deserializer newValue = Objects.requireNonNull(value, "deserializer");
    return new ImmutableDialobStoreConfig(
        this.client,
        this.repoName,
        this.headName,
        this.authorProvider,
        this.gidProvider,
        this.serializer,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDialobStoreConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDialobStoreConfig
        && equalTo((ImmutableDialobStoreConfig) another);
  }

  private boolean equalTo(ImmutableDialobStoreConfig another) {
    return client.equals(another.client)
        && repoName.equals(another.repoName)
        && headName.equals(another.headName)
        && authorProvider.equals(another.authorProvider)
        && gidProvider.equals(another.gidProvider)
        && serializer.equals(another.serializer)
        && deserializer.equals(another.deserializer);
  }

  /**
   * Computes a hash code from attributes: {@code client}, {@code repoName}, {@code headName}, {@code authorProvider}, {@code gidProvider}, {@code serializer}, {@code deserializer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + client.hashCode();
    h += (h << 5) + repoName.hashCode();
    h += (h << 5) + headName.hashCode();
    h += (h << 5) + authorProvider.hashCode();
    h += (h << 5) + gidProvider.hashCode();
    h += (h << 5) + serializer.hashCode();
    h += (h << 5) + deserializer.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DialobStoreConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DialobStoreConfig")
        .omitNullValues()
        .add("client", client)
        .add("repoName", repoName)
        .add("headName", headName)
        .add("authorProvider", authorProvider)
        .add("gidProvider", gidProvider)
        .add("serializer", serializer)
        .add("deserializer", deserializer)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobStoreConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DialobStoreConfig instance
   */
  public static ImmutableDialobStoreConfig copyOf(DialobStoreConfig instance) {
    if (instance instanceof ImmutableDialobStoreConfig) {
      return (ImmutableDialobStoreConfig) instance;
    }
    return ImmutableDialobStoreConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDialobStoreConfig ImmutableDialobStoreConfig}.
   * <pre>
   * ImmutableDialobStoreConfig.builder()
   *    .client(io.resys.thena.docdb.api.DocDB) // required {@link DialobStoreConfig#getClient() client}
   *    .repoName(String) // required {@link DialobStoreConfig#getRepoName() repoName}
   *    .headName(String) // required {@link DialobStoreConfig#getHeadName() headName}
   *    .authorProvider(io.dialob.client.spi.store.DialobStoreConfig.AuthorProvider) // required {@link DialobStoreConfig#getAuthorProvider() authorProvider}
   *    .gidProvider(io.dialob.client.spi.store.DialobStoreConfig.GidProvider) // required {@link DialobStoreConfig#getGidProvider() gidProvider}
   *    .serializer(io.dialob.client.spi.store.DialobStoreConfig.Serializer) // required {@link DialobStoreConfig#getSerializer() serializer}
   *    .deserializer(io.dialob.client.spi.store.DialobStoreConfig.Deserializer) // required {@link DialobStoreConfig#getDeserializer() deserializer}
   *    .build();
   * </pre>
   * @return A new ImmutableDialobStoreConfig builder
   */
  public static ImmutableDialobStoreConfig.Builder builder() {
    return new ImmutableDialobStoreConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDialobStoreConfig ImmutableDialobStoreConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStoreConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLIENT = 0x1L;
    private static final long INIT_BIT_REPO_NAME = 0x2L;
    private static final long INIT_BIT_HEAD_NAME = 0x4L;
    private static final long INIT_BIT_AUTHOR_PROVIDER = 0x8L;
    private static final long INIT_BIT_GID_PROVIDER = 0x10L;
    private static final long INIT_BIT_SERIALIZER = 0x20L;
    private static final long INIT_BIT_DESERIALIZER = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable DocDB client;
    private @Nullable String repoName;
    private @Nullable String headName;
    private @Nullable DialobStoreConfig.AuthorProvider authorProvider;
    private @Nullable DialobStoreConfig.GidProvider gidProvider;
    private @Nullable DialobStoreConfig.Serializer serializer;
    private @Nullable DialobStoreConfig.Deserializer deserializer;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DialobStoreConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStoreConfig instance) {
      Objects.requireNonNull(instance, "instance");
      client(instance.getClient());
      repoName(instance.getRepoName());
      headName(instance.getHeadName());
      authorProvider(instance.getAuthorProvider());
      gidProvider(instance.getGidProvider());
      serializer(instance.getSerializer());
      deserializer(instance.getDeserializer());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder client(DocDB client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getRepoName() repoName} attribute.
     * @param repoName The value for repoName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repoName(String repoName) {
      this.repoName = Objects.requireNonNull(repoName, "repoName");
      initBits &= ~INIT_BIT_REPO_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getHeadName() headName} attribute.
     * @param headName The value for headName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headName(String headName) {
      this.headName = Objects.requireNonNull(headName, "headName");
      initBits &= ~INIT_BIT_HEAD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getAuthorProvider() authorProvider} attribute.
     * @param authorProvider The value for authorProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder authorProvider(DialobStoreConfig.AuthorProvider authorProvider) {
      this.authorProvider = Objects.requireNonNull(authorProvider, "authorProvider");
      initBits &= ~INIT_BIT_AUTHOR_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getGidProvider() gidProvider} attribute.
     * @param gidProvider The value for gidProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gidProvider(DialobStoreConfig.GidProvider gidProvider) {
      this.gidProvider = Objects.requireNonNull(gidProvider, "gidProvider");
      initBits &= ~INIT_BIT_GID_PROVIDER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getSerializer() serializer} attribute.
     * @param serializer The value for serializer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder serializer(DialobStoreConfig.Serializer serializer) {
      this.serializer = Objects.requireNonNull(serializer, "serializer");
      initBits &= ~INIT_BIT_SERIALIZER;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStoreConfig#getDeserializer() deserializer} attribute.
     * @param deserializer The value for deserializer 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deserializer(DialobStoreConfig.Deserializer deserializer) {
      this.deserializer = Objects.requireNonNull(deserializer, "deserializer");
      initBits &= ~INIT_BIT_DESERIALIZER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDialobStoreConfig ImmutableDialobStoreConfig}.
     * @return An immutable instance of DialobStoreConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDialobStoreConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDialobStoreConfig(client, repoName, headName, authorProvider, gidProvider, serializer, deserializer);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_REPO_NAME) != 0) attributes.add("repoName");
      if ((initBits & INIT_BIT_HEAD_NAME) != 0) attributes.add("headName");
      if ((initBits & INIT_BIT_AUTHOR_PROVIDER) != 0) attributes.add("authorProvider");
      if ((initBits & INIT_BIT_GID_PROVIDER) != 0) attributes.add("gidProvider");
      if ((initBits & INIT_BIT_SERIALIZER) != 0) attributes.add("serializer");
      if ((initBits & INIT_BIT_DESERIALIZER) != 0) attributes.add("deserializer");
      return "Cannot build DialobStoreConfig, some of required attributes are not set " + attributes;
    }
  }
}
