package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireEvent.QuestionnaireCreatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireCreatedEvent.builder()}.
 */
@Generated(from = "QuestionnaireEvent.QuestionnaireCreatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableQuestionnaireCreatedEvent
    implements QuestionnaireEvent.QuestionnaireCreatedEvent {
  private final String questionnaireId;

  private ImmutableQuestionnaireCreatedEvent(String questionnaireId) {
    this.questionnaireId = questionnaireId;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireCreatedEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireCreatedEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireCreatedEvent(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireCreatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireCreatedEvent
        && equalTo((ImmutableQuestionnaireCreatedEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireCreatedEvent another) {
    return questionnaireId.equals(another.questionnaireId);
  }

  /**
   * Computes a hash code from attributes: {@code questionnaireId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + questionnaireId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireCreatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QuestionnaireCreatedEvent")
        .omitNullValues()
        .add("questionnaireId", questionnaireId)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireEvent.QuestionnaireCreatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireCreatedEvent instance
   */
  public static ImmutableQuestionnaireCreatedEvent copyOf(QuestionnaireEvent.QuestionnaireCreatedEvent instance) {
    if (instance instanceof ImmutableQuestionnaireCreatedEvent) {
      return (ImmutableQuestionnaireCreatedEvent) instance;
    }
    return ImmutableQuestionnaireCreatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireCreatedEvent ImmutableQuestionnaireCreatedEvent}.
   * <pre>
   * ImmutableQuestionnaireCreatedEvent.builder()
   *    .questionnaireId(String) // required {@link QuestionnaireEvent.QuestionnaireCreatedEvent#getQuestionnaireId() questionnaireId}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireCreatedEvent builder
   */
  public static ImmutableQuestionnaireCreatedEvent.Builder builder() {
    return new ImmutableQuestionnaireCreatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireCreatedEvent ImmutableQuestionnaireCreatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireEvent.QuestionnaireCreatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String questionnaireId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent.QuestionnaireCreatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent.QuestionnaireCreatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireCreatedEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireCreatedEvent ImmutableQuestionnaireCreatedEvent}.
     * @return An immutable instance of QuestionnaireCreatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireCreatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireCreatedEvent(questionnaireId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      return "Cannot build QuestionnaireCreatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
