package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.proto.Actions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireEvent.QuestionnaireActionsEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireActionsEvent.builder()}.
 */
@Generated(from = "QuestionnaireEvent.QuestionnaireActionsEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableQuestionnaireActionsEvent
    implements QuestionnaireEvent.QuestionnaireActionsEvent {
  private final String questionnaireId;
  private final Actions actions;

  private ImmutableQuestionnaireActionsEvent(String questionnaireId, Actions actions) {
    this.questionnaireId = questionnaireId;
    this.actions = actions;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @Override
  public Actions getActions() {
    return actions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireActionsEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireActionsEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireActionsEvent(newValue, this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireActionsEvent#getActions() actions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for actions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireActionsEvent withActions(Actions value) {
    if (this.actions == value) return this;
    Actions newValue = Objects.requireNonNull(value, "actions");
    return new ImmutableQuestionnaireActionsEvent(this.questionnaireId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireActionsEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireActionsEvent
        && equalTo((ImmutableQuestionnaireActionsEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireActionsEvent another) {
    return questionnaireId.equals(another.questionnaireId)
        && actions.equals(another.actions);
  }

  /**
   * Computes a hash code from attributes: {@code questionnaireId}, {@code actions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + questionnaireId.hashCode();
    h += (h << 5) + actions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireActionsEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QuestionnaireActionsEvent")
        .omitNullValues()
        .add("questionnaireId", questionnaireId)
        .add("actions", actions)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireEvent.QuestionnaireActionsEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireActionsEvent instance
   */
  public static ImmutableQuestionnaireActionsEvent copyOf(QuestionnaireEvent.QuestionnaireActionsEvent instance) {
    if (instance instanceof ImmutableQuestionnaireActionsEvent) {
      return (ImmutableQuestionnaireActionsEvent) instance;
    }
    return ImmutableQuestionnaireActionsEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireActionsEvent ImmutableQuestionnaireActionsEvent}.
   * <pre>
   * ImmutableQuestionnaireActionsEvent.builder()
   *    .questionnaireId(String) // required {@link QuestionnaireEvent.QuestionnaireActionsEvent#getQuestionnaireId() questionnaireId}
   *    .actions(io.dialob.api.proto.Actions) // required {@link QuestionnaireEvent.QuestionnaireActionsEvent#getActions() actions}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireActionsEvent builder
   */
  public static ImmutableQuestionnaireActionsEvent.Builder builder() {
    return new ImmutableQuestionnaireActionsEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireActionsEvent ImmutableQuestionnaireActionsEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireEvent.QuestionnaireActionsEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x1L;
    private static final long INIT_BIT_ACTIONS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String questionnaireId;
    private @Nullable Actions actions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent.QuestionnaireActionsEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent.QuestionnaireActionsEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof QuestionnaireEvent.QuestionnaireActionsEvent) {
        QuestionnaireEvent.QuestionnaireActionsEvent instance = (QuestionnaireEvent.QuestionnaireActionsEvent) object;
        actions(instance.getActions());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireActionsEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireActionsEvent#getActions() actions} attribute.
     * @param actions The value for actions 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder actions(Actions actions) {
      this.actions = Objects.requireNonNull(actions, "actions");
      initBits &= ~INIT_BIT_ACTIONS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireActionsEvent ImmutableQuestionnaireActionsEvent}.
     * @return An immutable instance of QuestionnaireActionsEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireActionsEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireActionsEvent(questionnaireId, actions);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      if ((initBits & INIT_BIT_ACTIONS) != 0) attributes.add("actions");
      return "Cannot build QuestionnaireActionsEvent, some of required attributes are not set " + attributes;
    }
  }
}
