package io.dialob.client.spi.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DistributedEvent.FormTaggedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormTaggedEvent.builder()}.
 */
@Generated(from = "DistributedEvent.FormTaggedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormTaggedEvent
    implements DistributedEvent.FormTaggedEvent {
  private final String formId;
  private final String source;
  private final String formName;
  private final String tagName;
  private final @Nullable String refName;

  private ImmutableFormTaggedEvent(
      String formId,
      String source,
      String formName,
      String tagName,
      @Nullable String refName) {
    this.formId = formId;
    this.source = source;
    this.formName = formName;
    this.tagName = tagName;
    this.refName = refName;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * @return The value of the {@code formName} attribute
   */
  @JsonProperty("formName")
  @Override
  public String getFormName() {
    return formName;
  }

  /**
   * @return The value of the {@code tagName} attribute
   */
  @JsonProperty("tagName")
  @Override
  public String getTagName() {
    return tagName;
  }

  /**
   * @return The value of the {@code refName} attribute
   */
  @JsonProperty("refName")
  @Override
  public @Nullable String getRefName() {
    return refName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormTaggedEvent#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(newValue, this.source, this.formName, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormTaggedEvent#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.formId, newValue, this.formName, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormTaggedEvent#getFormName() formName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withFormName(String value) {
    String newValue = Objects.requireNonNull(value, "formName");
    if (this.formName.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.formId, this.source, newValue, this.tagName, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormTaggedEvent#getTagName() tagName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tagName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withTagName(String value) {
    String newValue = Objects.requireNonNull(value, "tagName");
    if (this.tagName.equals(newValue)) return this;
    return new ImmutableFormTaggedEvent(this.formId, this.source, this.formName, newValue, this.refName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormTaggedEvent#getRefName() refName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormTaggedEvent withRefName(@Nullable String value) {
    if (Objects.equals(this.refName, value)) return this;
    return new ImmutableFormTaggedEvent(this.formId, this.source, this.formName, this.tagName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormTaggedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormTaggedEvent
        && equalTo((ImmutableFormTaggedEvent) another);
  }

  private boolean equalTo(ImmutableFormTaggedEvent another) {
    return formId.equals(another.formId)
        && source.equals(another.source)
        && formName.equals(another.formName)
        && tagName.equals(another.tagName)
        && Objects.equals(refName, another.refName);
  }

  /**
   * Computes a hash code from attributes: {@code formId}, {@code source}, {@code formName}, {@code tagName}, {@code refName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + formName.hashCode();
    h += (h << 5) + tagName.hashCode();
    h += (h << 5) + Objects.hashCode(refName);
    return h;
  }

  /**
   * Prints the immutable value {@code FormTaggedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormTaggedEvent")
        .omitNullValues()
        .add("formId", formId)
        .add("source", source)
        .add("formName", formName)
        .add("tagName", tagName)
        .add("refName", refName)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DistributedEvent.FormTaggedEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DistributedEvent.FormTaggedEvent {
    @Nullable String formId;
    @Nullable String source;
    @Nullable String formName;
    @Nullable String tagName;
    @Nullable String refName;
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("source")
    public void setSource(String source) {
      this.source = source;
    }
    @JsonProperty("formName")
    public void setFormName(String formName) {
      this.formName = formName;
    }
    @JsonProperty("tagName")
    public void setTagName(String tagName) {
      this.tagName = tagName;
    }
    @JsonProperty("refName")
    public void setRefName(@Nullable String refName) {
      this.refName = refName;
    }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTagName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormTaggedEvent fromJson(Json json) {
    ImmutableFormTaggedEvent.Builder builder = ImmutableFormTaggedEvent.builder();
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    if (json.formName != null) {
      builder.formName(json.formName);
    }
    if (json.tagName != null) {
      builder.tagName(json.tagName);
    }
    if (json.refName != null) {
      builder.refName(json.refName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DistributedEvent.FormTaggedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormTaggedEvent instance
   */
  public static ImmutableFormTaggedEvent copyOf(DistributedEvent.FormTaggedEvent instance) {
    if (instance instanceof ImmutableFormTaggedEvent) {
      return (ImmutableFormTaggedEvent) instance;
    }
    return ImmutableFormTaggedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormTaggedEvent ImmutableFormTaggedEvent}.
   * <pre>
   * ImmutableFormTaggedEvent.builder()
   *    .formId(String) // required {@link DistributedEvent.FormTaggedEvent#getFormId() formId}
   *    .source(String) // required {@link DistributedEvent.FormTaggedEvent#getSource() source}
   *    .formName(String) // required {@link DistributedEvent.FormTaggedEvent#getFormName() formName}
   *    .tagName(String) // required {@link DistributedEvent.FormTaggedEvent#getTagName() tagName}
   *    .refName(String | null) // nullable {@link DistributedEvent.FormTaggedEvent#getRefName() refName}
   *    .build();
   * </pre>
   * @return A new ImmutableFormTaggedEvent builder
   */
  public static ImmutableFormTaggedEvent.Builder builder() {
    return new ImmutableFormTaggedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormTaggedEvent ImmutableFormTaggedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DistributedEvent.FormTaggedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM_ID = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private static final long INIT_BIT_FORM_NAME = 0x4L;
    private static final long INIT_BIT_TAG_NAME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String formId;
    private @Nullable String source;
    private @Nullable String formName;
    private @Nullable String tagName;
    private @Nullable String refName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent.FormTaggedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent.FormTaggedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent.FormEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent.FormEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DistributedEvent) {
        DistributedEvent instance = (DistributedEvent) object;
        source(instance.getSource());
      }
      if (object instanceof DistributedEvent.FormTaggedEvent) {
        DistributedEvent.FormTaggedEvent instance = (DistributedEvent.FormTaggedEvent) object;
        tagName(instance.getTagName());
        @Nullable String refNameValue = instance.getRefName();
        if (refNameValue != null) {
          refName(refNameValue);
        }
        formName(instance.getFormName());
      }
      if (object instanceof DistributedEvent.FormEvent) {
        DistributedEvent.FormEvent instance = (DistributedEvent.FormEvent) object;
        formId(instance.getFormId());
      }
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormTaggedEvent#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormTaggedEvent#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormTaggedEvent#getFormName() formName} attribute.
     * @param formName The value for formName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formName")
    public final Builder formName(String formName) {
      this.formName = Objects.requireNonNull(formName, "formName");
      initBits &= ~INIT_BIT_FORM_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormTaggedEvent#getTagName() tagName} attribute.
     * @param tagName The value for tagName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tagName")
    public final Builder tagName(String tagName) {
      this.tagName = Objects.requireNonNull(tagName, "tagName");
      initBits &= ~INIT_BIT_TAG_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormTaggedEvent#getRefName() refName} attribute.
     * @param refName The value for refName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("refName")
    public final Builder refName(@Nullable String refName) {
      this.refName = refName;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormTaggedEvent ImmutableFormTaggedEvent}.
     * @return An immutable instance of FormTaggedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormTaggedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormTaggedEvent(formId, source, formName, tagName, refName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_FORM_NAME) != 0) attributes.add("formName");
      if ((initBits & INIT_BIT_TAG_NAME) != 0) attributes.add("tagName");
      return "Cannot build FormTaggedEvent, some of required attributes are not set " + attributes;
    }
  }
}
