package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.UpdateFormRevisionEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateFormRevisionEntry.builder()}.
 */
@Generated(from = "DialobComposer.UpdateFormRevisionEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateFormRevisionEntry
    implements DialobComposer.UpdateFormRevisionEntry {
  private final String id;
  private final String version;
  private final String revisionName;

  private ImmutableUpdateFormRevisionEntry(String id, String version, String revisionName) {
    this.id = id;
    this.version = version;
    this.revisionName = revisionName;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code revisionName} attribute
   */
  @JsonProperty("revisionName")
  @Override
  public String getRevisionName() {
    return revisionName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.UpdateFormRevisionEntry#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateFormRevisionEntry withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUpdateFormRevisionEntry(newValue, this.version, this.revisionName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.UpdateFormRevisionEntry#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateFormRevisionEntry withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableUpdateFormRevisionEntry(this.id, newValue, this.revisionName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.UpdateFormRevisionEntry#getRevisionName() revisionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revisionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateFormRevisionEntry withRevisionName(String value) {
    String newValue = Objects.requireNonNull(value, "revisionName");
    if (this.revisionName.equals(newValue)) return this;
    return new ImmutableUpdateFormRevisionEntry(this.id, this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateFormRevisionEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateFormRevisionEntry
        && equalTo((ImmutableUpdateFormRevisionEntry) another);
  }

  private boolean equalTo(ImmutableUpdateFormRevisionEntry another) {
    return id.equals(another.id)
        && version.equals(another.version)
        && revisionName.equals(another.revisionName);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code revisionName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + revisionName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateFormRevisionEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpdateFormRevisionEntry")
        .omitNullValues()
        .add("id", id)
        .add("version", version)
        .add("revisionName", revisionName)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.UpdateFormRevisionEntry", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.UpdateFormRevisionEntry {
    @Nullable String id;
    @Nullable String version;
    @Nullable String revisionName;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty("revisionName")
    public void setRevisionName(String revisionName) {
      this.revisionName = revisionName;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevisionName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUpdateFormRevisionEntry fromJson(Json json) {
    ImmutableUpdateFormRevisionEntry.Builder builder = ImmutableUpdateFormRevisionEntry.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.revisionName != null) {
      builder.revisionName(json.revisionName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.UpdateFormRevisionEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateFormRevisionEntry instance
   */
  public static ImmutableUpdateFormRevisionEntry copyOf(DialobComposer.UpdateFormRevisionEntry instance) {
    if (instance instanceof ImmutableUpdateFormRevisionEntry) {
      return (ImmutableUpdateFormRevisionEntry) instance;
    }
    return ImmutableUpdateFormRevisionEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateFormRevisionEntry ImmutableUpdateFormRevisionEntry}.
   * <pre>
   * ImmutableUpdateFormRevisionEntry.builder()
   *    .id(String) // required {@link DialobComposer.UpdateFormRevisionEntry#getId() id}
   *    .version(String) // required {@link DialobComposer.UpdateFormRevisionEntry#getVersion() version}
   *    .revisionName(String) // required {@link DialobComposer.UpdateFormRevisionEntry#getRevisionName() revisionName}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateFormRevisionEntry builder
   */
  public static ImmutableUpdateFormRevisionEntry.Builder builder() {
    return new ImmutableUpdateFormRevisionEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateFormRevisionEntry ImmutableUpdateFormRevisionEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.UpdateFormRevisionEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VERSION = 0x2L;
    private static final long INIT_BIT_REVISION_NAME = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String version;
    private @Nullable String revisionName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateFormRevisionEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.UpdateFormRevisionEntry instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      version(instance.getVersion());
      revisionName(instance.getRevisionName());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.UpdateFormRevisionEntry#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.UpdateFormRevisionEntry#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.UpdateFormRevisionEntry#getRevisionName() revisionName} attribute.
     * @param revisionName The value for revisionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revisionName")
    public final Builder revisionName(String revisionName) {
      this.revisionName = Objects.requireNonNull(revisionName, "revisionName");
      initBits &= ~INIT_BIT_REVISION_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateFormRevisionEntry ImmutableUpdateFormRevisionEntry}.
     * @return An immutable instance of UpdateFormRevisionEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateFormRevisionEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateFormRevisionEntry(id, version, revisionName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_REVISION_NAME) != 0) attributes.add("revisionName");
      return "Cannot build UpdateFormRevisionEntry, some of required attributes are not set " + attributes;
    }
  }
}
