package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.program.DialobProgram;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobClient.ProgramWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProgramWrapper.builder()}.
 */
@Generated(from = "DialobClient.ProgramWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableProgramWrapper implements DialobClient.ProgramWrapper {
  private final DialobStore.StoreEntity source;
  private final DialobDocument.FormDocument document;
  private final String id;
  private final DialobClient.ProgramStatus status;
  private final ImmutableList<DialobClient.ProgramMessage> errors;
  private final @Nullable DialobProgram program;

  private ImmutableProgramWrapper(
      DialobStore.StoreEntity source,
      DialobDocument.FormDocument document,
      String id,
      DialobClient.ProgramStatus status,
      ImmutableList<DialobClient.ProgramMessage> errors,
      @Nullable DialobProgram program) {
    this.source = source;
    this.document = document;
    this.id = id;
    this.status = status;
    this.errors = errors;
    this.program = program;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public DialobStore.StoreEntity getSource() {
    return source;
  }

  /**
   * @return The value of the {@code document} attribute
   */
  @Override
  public DialobDocument.FormDocument getDocument() {
    return document;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public DialobClient.ProgramStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @Override
  public ImmutableList<DialobClient.ProgramMessage> getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code program} attribute
   */
  @Override
  public Optional<DialobProgram> getProgram() {
    return Optional.ofNullable(program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramWrapper#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramWrapper withSource(DialobStore.StoreEntity value) {
    if (this.source == value) return this;
    DialobStore.StoreEntity newValue = Objects.requireNonNull(value, "source");
    return new ImmutableProgramWrapper(newValue, this.document, this.id, this.status, this.errors, this.program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramWrapper#getDocument() document} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for document
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramWrapper withDocument(DialobDocument.FormDocument value) {
    if (this.document == value) return this;
    DialobDocument.FormDocument newValue = Objects.requireNonNull(value, "document");
    return new ImmutableProgramWrapper(this.source, newValue, this.id, this.status, this.errors, this.program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramWrapper#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramWrapper withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableProgramWrapper(this.source, this.document, newValue, this.status, this.errors, this.program);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobClient.ProgramWrapper#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgramWrapper withStatus(DialobClient.ProgramStatus value) {
    if (this.status == value) return this;
    DialobClient.ProgramStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableProgramWrapper(this.source, this.document, this.id, newValue, this.errors, this.program);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobClient.ProgramWrapper#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgramWrapper withErrors(DialobClient.ProgramMessage... elements) {
    ImmutableList<DialobClient.ProgramMessage> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, newValue, this.program);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobClient.ProgramWrapper#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgramWrapper withErrors(Iterable<? extends DialobClient.ProgramMessage> elements) {
    if (this.errors == elements) return this;
    ImmutableList<DialobClient.ProgramMessage> newValue = ImmutableList.copyOf(elements);
    return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, newValue, this.program);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DialobClient.ProgramWrapper#getProgram() program} attribute.
   * @param value The value for program
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProgramWrapper withProgram(DialobProgram value) {
    @Nullable DialobProgram newValue = Objects.requireNonNull(value, "program");
    if (this.program == newValue) return this;
    return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, this.errors, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DialobClient.ProgramWrapper#getProgram() program} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for program
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableProgramWrapper withProgram(Optional<? extends DialobProgram> optional) {
    @Nullable DialobProgram value = optional.orElse(null);
    if (this.program == value) return this;
    return new ImmutableProgramWrapper(this.source, this.document, this.id, this.status, this.errors, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProgramWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProgramWrapper
        && equalTo((ImmutableProgramWrapper) another);
  }

  private boolean equalTo(ImmutableProgramWrapper another) {
    return source.equals(another.source)
        && document.equals(another.document)
        && id.equals(another.id)
        && status.equals(another.status)
        && errors.equals(another.errors)
        && Objects.equals(program, another.program);
  }

  /**
   * Computes a hash code from attributes: {@code source}, {@code document}, {@code id}, {@code status}, {@code errors}, {@code program}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + source.hashCode();
    h += (h << 5) + document.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + Objects.hashCode(program);
    return h;
  }

  /**
   * Prints the immutable value {@code ProgramWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ProgramWrapper")
        .omitNullValues()
        .add("source", source)
        .add("document", document)
        .add("id", id)
        .add("status", status)
        .add("errors", errors)
        .add("program", program)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DialobClient.ProgramWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProgramWrapper instance
   */
  public static ImmutableProgramWrapper copyOf(DialobClient.ProgramWrapper instance) {
    if (instance instanceof ImmutableProgramWrapper) {
      return (ImmutableProgramWrapper) instance;
    }
    return ImmutableProgramWrapper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProgramWrapper ImmutableProgramWrapper}.
   * <pre>
   * ImmutableProgramWrapper.builder()
   *    .source(io.dialob.client.api.DialobStore.StoreEntity) // required {@link DialobClient.ProgramWrapper#getSource() source}
   *    .document(io.dialob.client.api.DialobDocument.FormDocument) // required {@link DialobClient.ProgramWrapper#getDocument() document}
   *    .id(String) // required {@link DialobClient.ProgramWrapper#getId() id}
   *    .status(io.dialob.client.api.DialobClient.ProgramStatus) // required {@link DialobClient.ProgramWrapper#getStatus() status}
   *    .addErrors|addAllErrors(io.dialob.client.api.DialobClient.ProgramMessage) // {@link DialobClient.ProgramWrapper#getErrors() errors} elements
   *    .program(io.dialob.program.DialobProgram) // optional {@link DialobClient.ProgramWrapper#getProgram() program}
   *    .build();
   * </pre>
   * @return A new ImmutableProgramWrapper builder
   */
  public static ImmutableProgramWrapper.Builder builder() {
    return new ImmutableProgramWrapper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProgramWrapper ImmutableProgramWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobClient.ProgramWrapper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DOCUMENT = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_STATUS = 0x8L;
    private long initBits = 0xfL;

    private @Nullable DialobStore.StoreEntity source;
    private @Nullable DialobDocument.FormDocument document;
    private @Nullable String id;
    private @Nullable DialobClient.ProgramStatus status;
    private ImmutableList.Builder<DialobClient.ProgramMessage> errors = ImmutableList.builder();
    private @Nullable DialobProgram program;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProgramWrapper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobClient.ProgramWrapper instance) {
      Objects.requireNonNull(instance, "instance");
      source(instance.getSource());
      document(instance.getDocument());
      id(instance.getId());
      status(instance.getStatus());
      addAllErrors(instance.getErrors());
      Optional<DialobProgram> programOptional = instance.getProgram();
      if (programOptional.isPresent()) {
        program(programOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramWrapper#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder source(DialobStore.StoreEntity source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramWrapper#getDocument() document} attribute.
     * @param document The value for document 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder document(DialobDocument.FormDocument document) {
      this.document = Objects.requireNonNull(document, "document");
      initBits &= ~INIT_BIT_DOCUMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramWrapper#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobClient.ProgramWrapper#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(DialobClient.ProgramStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Adds one element to {@link DialobClient.ProgramWrapper#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(DialobClient.ProgramMessage element) {
      this.errors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobClient.ProgramWrapper#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addErrors(DialobClient.ProgramMessage... elements) {
      this.errors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobClient.ProgramWrapper#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errors(Iterable<? extends DialobClient.ProgramMessage> elements) {
      this.errors = ImmutableList.builder();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link DialobClient.ProgramWrapper#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllErrors(Iterable<? extends DialobClient.ProgramMessage> elements) {
      this.errors.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link DialobClient.ProgramWrapper#getProgram() program} to program.
     * @param program The value for program
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder program(DialobProgram program) {
      this.program = Objects.requireNonNull(program, "program");
      return this;
    }

    /**
     * Initializes the optional value {@link DialobClient.ProgramWrapper#getProgram() program} to program.
     * @param program The value for program
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder program(Optional<? extends DialobProgram> program) {
      this.program = program.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableProgramWrapper ImmutableProgramWrapper}.
     * @return An immutable instance of ProgramWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProgramWrapper build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProgramWrapper(source, document, id, status, errors.build(), program);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DOCUMENT) != 0) attributes.add("document");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build ProgramWrapper, some of required attributes are not set " + attributes;
    }
  }
}
