package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobDocument.FormRevisionDocument}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormRevisionDocument.builder()}.
 */
@Generated(from = "DialobDocument.FormRevisionDocument", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormRevisionDocument
    implements DialobDocument.FormRevisionDocument {
  private final @Nullable String id;
  private final @Nullable String version;
  private final @Nullable String description;
  private final String name;
  private final LocalDateTime created;
  private final String head;
  private final LocalDateTime updated;
  private final ImmutableList<DialobDocument.FormRevisionEntryDocument> entries;
  private final DialobDocument.DocumentType type;

  private ImmutableFormRevisionDocument(ImmutableFormRevisionDocument.Builder builder) {
    this.id = builder.id;
    this.version = builder.version;
    this.description = builder.description;
    this.name = builder.name;
    this.created = builder.created;
    this.head = builder.head;
    this.updated = builder.updated;
    this.entries = builder.entries.build();
    this.type = builder.type != null
        ? builder.type
        : Objects.requireNonNull(DialobDocument.FormRevisionDocument.super.getType(), "type");
  }

  private ImmutableFormRevisionDocument(
      @Nullable String id,
      @Nullable String version,
      @Nullable String description,
      String name,
      LocalDateTime created,
      String head,
      LocalDateTime updated,
      ImmutableList<DialobDocument.FormRevisionEntryDocument> entries,
      DialobDocument.DocumentType type) {
    this.id = id;
    this.version = version;
    this.description = description;
    this.name = name;
    this.created = created;
    this.head = head;
    this.updated = updated;
    this.entries = entries;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code head} attribute
   */
  @JsonProperty("head")
  @Override
  public String getHead() {
    return head;
  }

  /**
   * @return The value of the {@code updated} attribute
   */
  @JsonProperty("updated")
  @Override
  public LocalDateTime getUpdated() {
    return updated;
  }

  /**
   * @return The value of the {@code entries} attribute
   */
  @JsonProperty("entries")
  @Override
  public ImmutableList<DialobDocument.FormRevisionEntryDocument> getEntries() {
    return entries;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public DialobDocument.DocumentType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormRevisionDocument(
        value,
        this.version,
        this.description,
        this.name,
        this.created,
        this.head,
        this.updated,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withVersion(@Nullable String value) {
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableFormRevisionDocument(
        this.id,
        value,
        this.description,
        this.name,
        this.created,
        this.head,
        this.updated,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        value,
        this.name,
        this.created,
        this.head,
        this.updated,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        newValue,
        this.created,
        this.head,
        this.updated,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        this.name,
        newValue,
        this.head,
        this.updated,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getHead() head} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withHead(String value) {
    String newValue = Objects.requireNonNull(value, "head");
    if (this.head.equals(newValue)) return this;
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        this.name,
        this.created,
        newValue,
        this.updated,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getUpdated() updated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withUpdated(LocalDateTime value) {
    if (this.updated == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "updated");
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        this.name,
        this.created,
        this.head,
        newValue,
        this.entries,
        this.type);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobDocument.FormRevisionDocument#getEntries() entries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormRevisionDocument withEntries(DialobDocument.FormRevisionEntryDocument... elements) {
    ImmutableList<DialobDocument.FormRevisionEntryDocument> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        this.name,
        this.created,
        this.head,
        this.updated,
        newValue,
        this.type);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobDocument.FormRevisionDocument#getEntries() entries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of entries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormRevisionDocument withEntries(Iterable<? extends DialobDocument.FormRevisionEntryDocument> elements) {
    if (this.entries == elements) return this;
    ImmutableList<DialobDocument.FormRevisionEntryDocument> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        this.name,
        this.created,
        this.head,
        this.updated,
        newValue,
        this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormRevisionDocument#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormRevisionDocument withType(DialobDocument.DocumentType value) {
    if (this.type == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFormRevisionDocument(
        this.id,
        this.version,
        this.description,
        this.name,
        this.created,
        this.head,
        this.updated,
        this.entries,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormRevisionDocument} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormRevisionDocument
        && equalTo((ImmutableFormRevisionDocument) another);
  }

  private boolean equalTo(ImmutableFormRevisionDocument another) {
    return Objects.equals(id, another.id)
        && Objects.equals(version, another.version)
        && Objects.equals(description, another.description)
        && name.equals(another.name)
        && created.equals(another.created)
        && head.equals(another.head)
        && updated.equals(another.updated)
        && entries.equals(another.entries)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code description}, {@code name}, {@code created}, {@code head}, {@code updated}, {@code entries}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + head.hashCode();
    h += (h << 5) + updated.hashCode();
    h += (h << 5) + entries.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormRevisionDocument} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormRevisionDocument")
        .omitNullValues()
        .add("id", id)
        .add("version", version)
        .add("description", description)
        .add("name", name)
        .add("created", created)
        .add("head", head)
        .add("updated", updated)
        .add("entries", entries)
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobDocument.FormRevisionDocument", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobDocument.FormRevisionDocument {
    @Nullable String id;
    @Nullable String version;
    @Nullable String description;
    @Nullable String name;
    @Nullable LocalDateTime created;
    @Nullable String head;
    @Nullable LocalDateTime updated;
    @Nullable List<DialobDocument.FormRevisionEntryDocument> entries = ImmutableList.of();
    @Nullable DialobDocument.DocumentType type;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("head")
    public void setHead(String head) {
      this.head = head;
    }
    @JsonProperty("updated")
    public void setUpdated(LocalDateTime updated) {
      this.updated = updated;
    }
    @JsonProperty("entries")
    public void setEntries(List<DialobDocument.FormRevisionEntryDocument> entries) {
      this.entries = entries;
    }
    @JsonProperty("type")
    public void setType(DialobDocument.DocumentType type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public String getHead() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getUpdated() { throw new UnsupportedOperationException(); }
    @Override
    public List<DialobDocument.FormRevisionEntryDocument> getEntries() { throw new UnsupportedOperationException(); }
    @Override
    public DialobDocument.DocumentType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormRevisionDocument fromJson(Json json) {
    ImmutableFormRevisionDocument.Builder builder = ImmutableFormRevisionDocument.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.updated != null) {
      builder.updated(json.updated);
    }
    if (json.entries != null) {
      builder.addAllEntries(json.entries);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobDocument.FormRevisionDocument} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormRevisionDocument instance
   */
  public static ImmutableFormRevisionDocument copyOf(DialobDocument.FormRevisionDocument instance) {
    if (instance instanceof ImmutableFormRevisionDocument) {
      return (ImmutableFormRevisionDocument) instance;
    }
    return ImmutableFormRevisionDocument.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormRevisionDocument ImmutableFormRevisionDocument}.
   * <pre>
   * ImmutableFormRevisionDocument.builder()
   *    .id(String | null) // nullable {@link DialobDocument.FormRevisionDocument#getId() id}
   *    .version(String | null) // nullable {@link DialobDocument.FormRevisionDocument#getVersion() version}
   *    .description(String | null) // nullable {@link DialobDocument.FormRevisionDocument#getDescription() description}
   *    .name(String) // required {@link DialobDocument.FormRevisionDocument#getName() name}
   *    .created(java.time.LocalDateTime) // required {@link DialobDocument.FormRevisionDocument#getCreated() created}
   *    .head(String) // required {@link DialobDocument.FormRevisionDocument#getHead() head}
   *    .updated(java.time.LocalDateTime) // required {@link DialobDocument.FormRevisionDocument#getUpdated() updated}
   *    .addEntries|addAllEntries(io.dialob.client.api.DialobDocument.FormRevisionEntryDocument) // {@link DialobDocument.FormRevisionDocument#getEntries() entries} elements
   *    .type(io.dialob.client.api.DialobDocument.DocumentType) // optional {@link DialobDocument.FormRevisionDocument#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableFormRevisionDocument builder
   */
  public static ImmutableFormRevisionDocument.Builder builder() {
    return new ImmutableFormRevisionDocument.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormRevisionDocument ImmutableFormRevisionDocument}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobDocument.FormRevisionDocument", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_CREATED = 0x2L;
    private static final long INIT_BIT_HEAD = 0x4L;
    private static final long INIT_BIT_UPDATED = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String version;
    private @Nullable String description;
    private @Nullable String name;
    private @Nullable LocalDateTime created;
    private @Nullable String head;
    private @Nullable LocalDateTime updated;
    private ImmutableList.Builder<DialobDocument.FormRevisionEntryDocument> entries = ImmutableList.builder();
    private @Nullable DialobDocument.DocumentType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobDocument.FormRevisionDocument} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument.FormRevisionDocument instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobDocument} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof DialobDocument.FormRevisionDocument) {
        DialobDocument.FormRevisionDocument instance = (DialobDocument.FormRevisionDocument) object;
        head(instance.getHead());
        addAllEntries(instance.getEntries());
        if ((bits & 0x1L) == 0) {
          type(instance.getType());
          bits |= 0x1L;
        }
        updated(instance.getUpdated());
      }
      if (object instanceof DialobDocument) {
        DialobDocument instance = (DialobDocument) object;
        name(instance.getName());
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        if ((bits & 0x1L) == 0) {
          type(instance.getType());
          bits |= 0x1L;
        }
        @Nullable String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
        created(instance.getCreated());
      }
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getHead() head} attribute.
     * @param head The value for head 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("head")
    public final Builder head(String head) {
      this.head = Objects.requireNonNull(head, "head");
      initBits &= ~INIT_BIT_HEAD;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getUpdated() updated} attribute.
     * @param updated The value for updated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("updated")
    public final Builder updated(LocalDateTime updated) {
      this.updated = Objects.requireNonNull(updated, "updated");
      initBits &= ~INIT_BIT_UPDATED;
      return this;
    }

    /**
     * Adds one element to {@link DialobDocument.FormRevisionDocument#getEntries() entries} list.
     * @param element A entries element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(DialobDocument.FormRevisionEntryDocument element) {
      this.entries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobDocument.FormRevisionDocument#getEntries() entries} list.
     * @param elements An array of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEntries(DialobDocument.FormRevisionEntryDocument... elements) {
      this.entries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobDocument.FormRevisionDocument#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("entries")
    public final Builder entries(Iterable<? extends DialobDocument.FormRevisionEntryDocument> elements) {
      this.entries = ImmutableList.builder();
      return addAllEntries(elements);
    }

    /**
     * Adds elements to {@link DialobDocument.FormRevisionDocument#getEntries() entries} list.
     * @param elements An iterable of entries elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEntries(Iterable<? extends DialobDocument.FormRevisionEntryDocument> elements) {
      this.entries.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormRevisionDocument#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DialobDocument.FormRevisionDocument#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(DialobDocument.DocumentType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormRevisionDocument ImmutableFormRevisionDocument}.
     * @return An immutable instance of FormRevisionDocument
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormRevisionDocument build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormRevisionDocument(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_HEAD) != 0) attributes.add("head");
      if ((initBits & INIT_BIT_UPDATED) != 0) attributes.add("updated");
      return "Cannot build FormRevisionDocument, some of required attributes are not set " + attributes;
    }
  }
}
