package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobDocument.FormReleaseValueDocument}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormReleaseValueDocument.builder()}.
 */
@Generated(from = "DialobDocument.FormReleaseValueDocument", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormReleaseValueDocument
    implements DialobDocument.FormReleaseValueDocument {
  private final String hash;
  private final DialobDocument.DocumentType bodyType;
  private final @Nullable String description;
  private final String commands;

  private ImmutableFormReleaseValueDocument(
      String hash,
      DialobDocument.DocumentType bodyType,
      @Nullable String description,
      String commands) {
    this.hash = hash;
    this.bodyType = bodyType;
    this.description = description;
    this.commands = commands;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public DialobDocument.DocumentType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code commands} attribute
   */
  @JsonProperty("commands")
  @Override
  public String getCommands() {
    return commands;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseValueDocument#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseValueDocument withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableFormReleaseValueDocument(newValue, this.bodyType, this.description, this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseValueDocument#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseValueDocument withBodyType(DialobDocument.DocumentType value) {
    if (this.bodyType == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableFormReleaseValueDocument(this.hash, newValue, this.description, this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseValueDocument#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseValueDocument withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFormReleaseValueDocument(this.hash, this.bodyType, value, this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseValueDocument#getCommands() commands} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commands
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseValueDocument withCommands(String value) {
    String newValue = Objects.requireNonNull(value, "commands");
    if (this.commands.equals(newValue)) return this;
    return new ImmutableFormReleaseValueDocument(this.hash, this.bodyType, this.description, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormReleaseValueDocument} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormReleaseValueDocument
        && equalTo((ImmutableFormReleaseValueDocument) another);
  }

  private boolean equalTo(ImmutableFormReleaseValueDocument another) {
    return hash.equals(another.hash)
        && bodyType.equals(another.bodyType)
        && Objects.equals(description, another.description)
        && commands.equals(another.commands);
  }

  /**
   * Computes a hash code from attributes: {@code hash}, {@code bodyType}, {@code description}, {@code commands}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + commands.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormReleaseValueDocument} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormReleaseValueDocument")
        .omitNullValues()
        .add("hash", hash)
        .add("bodyType", bodyType)
        .add("description", description)
        .add("commands", commands)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobDocument.FormReleaseValueDocument", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobDocument.FormReleaseValueDocument {
    @Nullable String hash;
    @Nullable DialobDocument.DocumentType bodyType;
    @Nullable String description;
    @Nullable String commands;
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("bodyType")
    public void setBodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("commands")
    public void setCommands(String commands) {
      this.commands = commands;
    }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public DialobDocument.DocumentType getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommands() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormReleaseValueDocument fromJson(Json json) {
    ImmutableFormReleaseValueDocument.Builder builder = ImmutableFormReleaseValueDocument.builder();
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.commands != null) {
      builder.commands(json.commands);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobDocument.FormReleaseValueDocument} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormReleaseValueDocument instance
   */
  public static ImmutableFormReleaseValueDocument copyOf(DialobDocument.FormReleaseValueDocument instance) {
    if (instance instanceof ImmutableFormReleaseValueDocument) {
      return (ImmutableFormReleaseValueDocument) instance;
    }
    return ImmutableFormReleaseValueDocument.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormReleaseValueDocument ImmutableFormReleaseValueDocument}.
   * <pre>
   * ImmutableFormReleaseValueDocument.builder()
   *    .hash(String) // required {@link DialobDocument.FormReleaseValueDocument#getHash() hash}
   *    .bodyType(io.dialob.client.api.DialobDocument.DocumentType) // required {@link DialobDocument.FormReleaseValueDocument#getBodyType() bodyType}
   *    .description(String | null) // nullable {@link DialobDocument.FormReleaseValueDocument#getDescription() description}
   *    .commands(String) // required {@link DialobDocument.FormReleaseValueDocument#getCommands() commands}
   *    .build();
   * </pre>
   * @return A new ImmutableFormReleaseValueDocument builder
   */
  public static ImmutableFormReleaseValueDocument.Builder builder() {
    return new ImmutableFormReleaseValueDocument.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormReleaseValueDocument ImmutableFormReleaseValueDocument}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobDocument.FormReleaseValueDocument", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HASH = 0x1L;
    private static final long INIT_BIT_BODY_TYPE = 0x2L;
    private static final long INIT_BIT_COMMANDS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String hash;
    private @Nullable DialobDocument.DocumentType bodyType;
    private @Nullable String description;
    private @Nullable String commands;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormReleaseValueDocument} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument.FormReleaseValueDocument instance) {
      Objects.requireNonNull(instance, "instance");
      hash(instance.getHash());
      bodyType(instance.getBodyType());
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      commands(instance.getCommands());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseValueDocument#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseValueDocument#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseValueDocument#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseValueDocument#getCommands() commands} attribute.
     * @param commands The value for commands 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commands")
    public final Builder commands(String commands) {
      this.commands = Objects.requireNonNull(commands, "commands");
      initBits &= ~INIT_BIT_COMMANDS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormReleaseValueDocument ImmutableFormReleaseValueDocument}.
     * @return An immutable instance of FormReleaseValueDocument
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormReleaseValueDocument build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormReleaseValueDocument(hash, bodyType, description, commands);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_COMMANDS) != 0) attributes.add("commands");
      return "Cannot build FormReleaseValueDocument, some of required attributes are not set " + attributes;
    }
  }
}
