package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobDocument.FormReleaseDocument}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormReleaseDocument.builder()}.
 */
@Generated(from = "DialobDocument.FormReleaseDocument", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormReleaseDocument
    implements DialobDocument.FormReleaseDocument {
  private final @Nullable String id;
  private final @Nullable String version;
  private final @Nullable String description;
  private final String name;
  private final LocalDateTime created;
  private final ImmutableList<DialobDocument.FormReleaseValueDocument> values;
  private final DialobDocument.DocumentType type;

  private ImmutableFormReleaseDocument(ImmutableFormReleaseDocument.Builder builder) {
    this.id = builder.id;
    this.version = builder.version;
    this.description = builder.description;
    this.name = builder.name;
    this.created = builder.created;
    this.values = builder.values.build();
    this.type = builder.type != null
        ? builder.type
        : Objects.requireNonNull(DialobDocument.FormReleaseDocument.super.getType(), "type");
  }

  private ImmutableFormReleaseDocument(
      @Nullable String id,
      @Nullable String version,
      @Nullable String description,
      String name,
      LocalDateTime created,
      ImmutableList<DialobDocument.FormReleaseValueDocument> values,
      DialobDocument.DocumentType type) {
    this.id = id;
    this.version = version;
    this.description = description;
    this.name = name;
    this.created = created;
    this.values = values;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @JsonProperty("values")
  @Override
  public ImmutableList<DialobDocument.FormReleaseValueDocument> getValues() {
    return values;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public DialobDocument.DocumentType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseDocument#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseDocument withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormReleaseDocument(value, this.version, this.description, this.name, this.created, this.values, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseDocument#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseDocument withVersion(@Nullable String value) {
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableFormReleaseDocument(this.id, value, this.description, this.name, this.created, this.values, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseDocument#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseDocument withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFormReleaseDocument(this.id, this.version, value, this.name, this.created, this.values, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseDocument#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseDocument withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFormReleaseDocument(this.id, this.version, this.description, newValue, this.created, this.values, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseDocument#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseDocument withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, newValue, this.values, this.type);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobDocument.FormReleaseDocument#getValues() values}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormReleaseDocument withValues(DialobDocument.FormReleaseValueDocument... elements) {
    ImmutableList<DialobDocument.FormReleaseValueDocument> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, this.created, newValue, this.type);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobDocument.FormReleaseDocument#getValues() values}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of values elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormReleaseDocument withValues(Iterable<? extends DialobDocument.FormReleaseValueDocument> elements) {
    if (this.values == elements) return this;
    ImmutableList<DialobDocument.FormReleaseValueDocument> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, this.created, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormReleaseDocument#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormReleaseDocument withType(DialobDocument.DocumentType value) {
    if (this.type == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFormReleaseDocument(this.id, this.version, this.description, this.name, this.created, this.values, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormReleaseDocument} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormReleaseDocument
        && equalTo((ImmutableFormReleaseDocument) another);
  }

  private boolean equalTo(ImmutableFormReleaseDocument another) {
    return Objects.equals(id, another.id)
        && Objects.equals(version, another.version)
        && Objects.equals(description, another.description)
        && name.equals(another.name)
        && created.equals(another.created)
        && values.equals(another.values)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code description}, {@code name}, {@code created}, {@code values}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + values.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormReleaseDocument} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormReleaseDocument")
        .omitNullValues()
        .add("id", id)
        .add("version", version)
        .add("description", description)
        .add("name", name)
        .add("created", created)
        .add("values", values)
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobDocument.FormReleaseDocument", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobDocument.FormReleaseDocument {
    @Nullable String id;
    @Nullable String version;
    @Nullable String description;
    @Nullable String name;
    @Nullable LocalDateTime created;
    @Nullable List<DialobDocument.FormReleaseValueDocument> values = ImmutableList.of();
    @Nullable DialobDocument.DocumentType type;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("values")
    public void setValues(List<DialobDocument.FormReleaseValueDocument> values) {
      this.values = values;
    }
    @JsonProperty("type")
    public void setType(DialobDocument.DocumentType type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public List<DialobDocument.FormReleaseValueDocument> getValues() { throw new UnsupportedOperationException(); }
    @Override
    public DialobDocument.DocumentType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormReleaseDocument fromJson(Json json) {
    ImmutableFormReleaseDocument.Builder builder = ImmutableFormReleaseDocument.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.values != null) {
      builder.addAllValues(json.values);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobDocument.FormReleaseDocument} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormReleaseDocument instance
   */
  public static ImmutableFormReleaseDocument copyOf(DialobDocument.FormReleaseDocument instance) {
    if (instance instanceof ImmutableFormReleaseDocument) {
      return (ImmutableFormReleaseDocument) instance;
    }
    return ImmutableFormReleaseDocument.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormReleaseDocument ImmutableFormReleaseDocument}.
   * <pre>
   * ImmutableFormReleaseDocument.builder()
   *    .id(String | null) // nullable {@link DialobDocument.FormReleaseDocument#getId() id}
   *    .version(String | null) // nullable {@link DialobDocument.FormReleaseDocument#getVersion() version}
   *    .description(String | null) // nullable {@link DialobDocument.FormReleaseDocument#getDescription() description}
   *    .name(String) // required {@link DialobDocument.FormReleaseDocument#getName() name}
   *    .created(java.time.LocalDateTime) // required {@link DialobDocument.FormReleaseDocument#getCreated() created}
   *    .addValues|addAllValues(io.dialob.client.api.DialobDocument.FormReleaseValueDocument) // {@link DialobDocument.FormReleaseDocument#getValues() values} elements
   *    .type(io.dialob.client.api.DialobDocument.DocumentType) // optional {@link DialobDocument.FormReleaseDocument#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableFormReleaseDocument builder
   */
  public static ImmutableFormReleaseDocument.Builder builder() {
    return new ImmutableFormReleaseDocument.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormReleaseDocument ImmutableFormReleaseDocument}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobDocument.FormReleaseDocument", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_CREATED = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String version;
    private @Nullable String description;
    private @Nullable String name;
    private @Nullable LocalDateTime created;
    private ImmutableList.Builder<DialobDocument.FormReleaseValueDocument> values = ImmutableList.builder();
    private @Nullable DialobDocument.DocumentType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobDocument} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobDocument.FormReleaseDocument} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument.FormReleaseDocument instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof DialobDocument) {
        DialobDocument instance = (DialobDocument) object;
        name(instance.getName());
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        if ((bits & 0x2L) == 0) {
          type(instance.getType());
          bits |= 0x2L;
        }
        @Nullable String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
        if ((bits & 0x1L) == 0) {
          created(instance.getCreated());
          bits |= 0x1L;
        }
      }
      if (object instanceof DialobDocument.FormReleaseDocument) {
        DialobDocument.FormReleaseDocument instance = (DialobDocument.FormReleaseDocument) object;
        if ((bits & 0x2L) == 0) {
          type(instance.getType());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          created(instance.getCreated());
          bits |= 0x1L;
        }
        addAllValues(instance.getValues());
      }
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseDocument#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseDocument#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseDocument#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseDocument#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseDocument#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Adds one element to {@link DialobDocument.FormReleaseDocument#getValues() values} list.
     * @param element A values element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(DialobDocument.FormReleaseValueDocument element) {
      this.values.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobDocument.FormReleaseDocument#getValues() values} list.
     * @param elements An array of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValues(DialobDocument.FormReleaseValueDocument... elements) {
      this.values.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobDocument.FormReleaseDocument#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("values")
    public final Builder values(Iterable<? extends DialobDocument.FormReleaseValueDocument> elements) {
      this.values = ImmutableList.builder();
      return addAllValues(elements);
    }

    /**
     * Adds elements to {@link DialobDocument.FormReleaseDocument#getValues() values} list.
     * @param elements An iterable of values elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValues(Iterable<? extends DialobDocument.FormReleaseValueDocument> elements) {
      this.values.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormReleaseDocument#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DialobDocument.FormReleaseDocument#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(DialobDocument.DocumentType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormReleaseDocument ImmutableFormReleaseDocument}.
     * @return An immutable instance of FormReleaseDocument
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormReleaseDocument build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormReleaseDocument(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      return "Cannot build FormReleaseDocument, some of required attributes are not set " + attributes;
    }
  }
}
