package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.Form;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobDocument.FormDocument}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormDocument.builder()}.
 */
@Generated(from = "DialobDocument.FormDocument", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormDocument implements DialobDocument.FormDocument {
  private final @Nullable String id;
  private final @Nullable String version;
  private final @Nullable String description;
  private final LocalDateTime created;
  private final Form data;
  private final LocalDateTime updated;
  private final DialobDocument.DocumentType type;
  private final String name;

  private ImmutableFormDocument(ImmutableFormDocument.Builder builder) {
    this.id = builder.id;
    this.version = builder.version;
    this.description = builder.description;
    this.created = builder.created;
    this.data = builder.data;
    this.updated = builder.updated;
    if (builder.type != null) {
      initShim.type(builder.type);
    }
    if (builder.name != null) {
      initShim.name(builder.name);
    }
    this.type = initShim.getType();
    this.name = initShim.getName();
    this.initShim = null;
  }

  private ImmutableFormDocument(
      @Nullable String id,
      @Nullable String version,
      @Nullable String description,
      LocalDateTime created,
      Form data,
      LocalDateTime updated,
      DialobDocument.DocumentType type,
      String name) {
    this.id = id;
    this.version = version;
    this.description = description;
    this.created = created;
    this.data = data;
    this.updated = updated;
    this.type = type;
    this.name = name;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DialobDocument.FormDocument", generator = "Immutables")
  private final class InitShim {
    private byte typeBuildStage = STAGE_UNINITIALIZED;
    private DialobDocument.DocumentType type;

    DialobDocument.DocumentType getType() {
      if (typeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (typeBuildStage == STAGE_UNINITIALIZED) {
        typeBuildStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(getTypeInitialize(), "type");
        typeBuildStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void type(DialobDocument.DocumentType type) {
      this.type = type;
      typeBuildStage = STAGE_INITIALIZED;
    }

    private byte nameBuildStage = STAGE_UNINITIALIZED;
    private String name;

    String getName() {
      if (nameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nameBuildStage == STAGE_UNINITIALIZED) {
        nameBuildStage = STAGE_INITIALIZING;
        this.name = Objects.requireNonNull(getNameInitialize(), "name");
        nameBuildStage = STAGE_INITIALIZED;
      }
      return this.name;
    }

    void name(String name) {
      this.name = name;
      nameBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (typeBuildStage == STAGE_INITIALIZING) attributes.add("type");
      if (nameBuildStage == STAGE_INITIALIZING) attributes.add("name");
      return "Cannot build FormDocument, attribute initializers form cycle " + attributes;
    }
  }

  private DialobDocument.DocumentType getTypeInitialize() {
    return DialobDocument.FormDocument.super.getType();
  }

  private String getNameInitialize() {
    return DialobDocument.FormDocument.super.getName();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty("data")
  @Override
  public Form getData() {
    return data;
  }

  /**
   * @return The value of the {@code updated} attribute
   */
  @JsonProperty("updated")
  @Override
  public LocalDateTime getUpdated() {
    return updated;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public DialobDocument.DocumentType getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getName()
        : this.name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormDocument(
        value,
        this.version,
        this.description,
        this.created,
        this.data,
        this.updated,
        this.type,
        this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withVersion(@Nullable String value) {
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableFormDocument(this.id, value, this.description, this.created, this.data, this.updated, this.type, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableFormDocument(this.id, this.version, value, this.created, this.data, this.updated, this.type, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableFormDocument(
        this.id,
        this.version,
        this.description,
        newValue,
        this.data,
        this.updated,
        this.type,
        this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getData() data} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for data
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withData(Form value) {
    if (this.data == value) return this;
    Form newValue = Objects.requireNonNull(value, "data");
    return new ImmutableFormDocument(
        this.id,
        this.version,
        this.description,
        this.created,
        newValue,
        this.updated,
        this.type,
        this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getUpdated() updated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updated
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withUpdated(LocalDateTime value) {
    if (this.updated == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "updated");
    return new ImmutableFormDocument(
        this.id,
        this.version,
        this.description,
        this.created,
        this.data,
        newValue,
        this.type,
        this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withType(DialobDocument.DocumentType value) {
    if (this.type == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFormDocument(
        this.id,
        this.version,
        this.description,
        this.created,
        this.data,
        this.updated,
        newValue,
        this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobDocument.FormDocument#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDocument withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFormDocument(
        this.id,
        this.version,
        this.description,
        this.created,
        this.data,
        this.updated,
        this.type,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormDocument} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormDocument
        && equalTo((ImmutableFormDocument) another);
  }

  private boolean equalTo(ImmutableFormDocument another) {
    return Objects.equals(id, another.id)
        && Objects.equals(version, another.version)
        && Objects.equals(description, another.description)
        && created.equals(another.created)
        && data.equals(another.data)
        && updated.equals(another.updated)
        && type.equals(another.type)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code version}, {@code description}, {@code created}, {@code data}, {@code updated}, {@code type}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + created.hashCode();
    h += (h << 5) + data.hashCode();
    h += (h << 5) + updated.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormDocument} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormDocument")
        .omitNullValues()
        .add("id", id)
        .add("version", version)
        .add("description", description)
        .add("created", created)
        .add("data", data)
        .add("updated", updated)
        .add("type", type)
        .add("name", name)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobDocument.FormDocument", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobDocument.FormDocument {
    @Nullable String id;
    @Nullable String version;
    @Nullable String description;
    @Nullable LocalDateTime created;
    @Nullable Form data;
    @Nullable LocalDateTime updated;
    @Nullable DialobDocument.DocumentType type;
    @Nullable String name;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("data")
    public void setData(Form data) {
      this.data = data;
    }
    @JsonProperty("updated")
    public void setUpdated(LocalDateTime updated) {
      this.updated = updated;
    }
    @JsonProperty("type")
    public void setType(DialobDocument.DocumentType type) {
      this.type = type;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public Form getData() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getUpdated() { throw new UnsupportedOperationException(); }
    @Override
    public DialobDocument.DocumentType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormDocument fromJson(Json json) {
    ImmutableFormDocument.Builder builder = ImmutableFormDocument.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.updated != null) {
      builder.updated(json.updated);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobDocument.FormDocument} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormDocument instance
   */
  public static ImmutableFormDocument copyOf(DialobDocument.FormDocument instance) {
    if (instance instanceof ImmutableFormDocument) {
      return (ImmutableFormDocument) instance;
    }
    return ImmutableFormDocument.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormDocument ImmutableFormDocument}.
   * <pre>
   * ImmutableFormDocument.builder()
   *    .id(String | null) // nullable {@link DialobDocument.FormDocument#getId() id}
   *    .version(String | null) // nullable {@link DialobDocument.FormDocument#getVersion() version}
   *    .description(String | null) // nullable {@link DialobDocument.FormDocument#getDescription() description}
   *    .created(java.time.LocalDateTime) // required {@link DialobDocument.FormDocument#getCreated() created}
   *    .data(io.dialob.api.form.Form) // required {@link DialobDocument.FormDocument#getData() data}
   *    .updated(java.time.LocalDateTime) // required {@link DialobDocument.FormDocument#getUpdated() updated}
   *    .type(io.dialob.client.api.DialobDocument.DocumentType) // optional {@link DialobDocument.FormDocument#getType() type}
   *    .name(String) // optional {@link DialobDocument.FormDocument#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableFormDocument builder
   */
  public static ImmutableFormDocument.Builder builder() {
    return new ImmutableFormDocument.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormDocument ImmutableFormDocument}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobDocument.FormDocument", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CREATED = 0x1L;
    private static final long INIT_BIT_DATA = 0x2L;
    private static final long INIT_BIT_UPDATED = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String version;
    private @Nullable String description;
    private @Nullable LocalDateTime created;
    private @Nullable Form data;
    private @Nullable LocalDateTime updated;
    private @Nullable DialobDocument.DocumentType type;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobDocument.FormDocument} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument.FormDocument instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobDocument} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobDocument instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof DialobDocument.FormDocument) {
        DialobDocument.FormDocument instance = (DialobDocument.FormDocument) object;
        if ((bits & 0x1L) == 0) {
          name(instance.getName());
          bits |= 0x1L;
        }
        data(instance.getData());
        if ((bits & 0x2L) == 0) {
          type(instance.getType());
          bits |= 0x2L;
        }
        updated(instance.getUpdated());
      }
      if (object instanceof DialobDocument) {
        DialobDocument instance = (DialobDocument) object;
        if ((bits & 0x1L) == 0) {
          name(instance.getName());
          bits |= 0x1L;
        }
        @Nullable String descriptionValue = instance.getDescription();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        if ((bits & 0x2L) == 0) {
          type(instance.getType());
          bits |= 0x2L;
        }
        @Nullable String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
        created(instance.getCreated());
      }
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getData() data} attribute.
     * @param data The value for data 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("data")
    public final Builder data(Form data) {
      this.data = Objects.requireNonNull(data, "data");
      initBits &= ~INIT_BIT_DATA;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getUpdated() updated} attribute.
     * @param updated The value for updated 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("updated")
    public final Builder updated(LocalDateTime updated) {
      this.updated = Objects.requireNonNull(updated, "updated");
      initBits &= ~INIT_BIT_UPDATED;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DialobDocument.FormDocument#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(DialobDocument.DocumentType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the value for the {@link DialobDocument.FormDocument#getName() name} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DialobDocument.FormDocument#getName() name}.</em>
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormDocument ImmutableFormDocument}.
     * @return An immutable instance of FormDocument
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormDocument build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormDocument(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      if ((initBits & INIT_BIT_UPDATED) != 0) attributes.add("updated");
      return "Cannot build FormDocument, some of required attributes are not set " + attributes;
    }
  }
}
