package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.EmptyCommand}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEmptyCommand.builder()}.
 */
@Generated(from = "DialobStore.EmptyCommand", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEmptyCommand implements DialobStore.EmptyCommand {
  private final DialobDocument.DocumentType bodyType;
  private final String id;
  private final String description;

  private ImmutableEmptyCommand(
      DialobDocument.DocumentType bodyType,
      String id,
      String description) {
    this.bodyType = bodyType;
    this.id = id;
    this.description = description;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public DialobDocument.DocumentType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.EmptyCommand#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmptyCommand withBodyType(DialobDocument.DocumentType value) {
    if (this.bodyType == value) return this;
    DialobDocument.DocumentType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableEmptyCommand(newValue, this.id, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.EmptyCommand#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmptyCommand withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableEmptyCommand(this.bodyType, newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.EmptyCommand#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEmptyCommand withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableEmptyCommand(this.bodyType, this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEmptyCommand} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEmptyCommand
        && equalTo((ImmutableEmptyCommand) another);
  }

  private boolean equalTo(ImmutableEmptyCommand another) {
    return bodyType.equals(another.bodyType)
        && id.equals(another.id)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code bodyType}, {@code id}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EmptyCommand} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EmptyCommand")
        .omitNullValues()
        .add("bodyType", bodyType)
        .add("id", id)
        .add("description", description)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.EmptyCommand", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.EmptyCommand {
    @Nullable DialobDocument.DocumentType bodyType;
    @Nullable String id;
    @Nullable String description;
    @JsonProperty("bodyType")
    public void setBodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @Override
    public DialobDocument.DocumentType getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEmptyCommand fromJson(Json json) {
    ImmutableEmptyCommand.Builder builder = ImmutableEmptyCommand.builder();
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.EmptyCommand} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EmptyCommand instance
   */
  public static ImmutableEmptyCommand copyOf(DialobStore.EmptyCommand instance) {
    if (instance instanceof ImmutableEmptyCommand) {
      return (ImmutableEmptyCommand) instance;
    }
    return ImmutableEmptyCommand.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEmptyCommand ImmutableEmptyCommand}.
   * <pre>
   * ImmutableEmptyCommand.builder()
   *    .bodyType(io.dialob.client.api.DialobDocument.DocumentType) // required {@link DialobStore.EmptyCommand#getBodyType() bodyType}
   *    .id(String) // required {@link DialobStore.EmptyCommand#getId() id}
   *    .description(String) // required {@link DialobStore.EmptyCommand#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableEmptyCommand builder
   */
  public static ImmutableEmptyCommand.Builder builder() {
    return new ImmutableEmptyCommand.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEmptyCommand ImmutableEmptyCommand}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.EmptyCommand", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BODY_TYPE = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private long initBits = 0x7L;

    private @Nullable DialobDocument.DocumentType bodyType;
    private @Nullable String id;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.EmptyCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.EmptyCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.StoreCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DialobStore.EmptyCommand) {
        DialobStore.EmptyCommand instance = (DialobStore.EmptyCommand) object;
        description(instance.getDescription());
        id(instance.getId());
      }
      if (object instanceof DialobStore.StoreCommand) {
        DialobStore.StoreCommand instance = (DialobStore.StoreCommand) object;
        bodyType(instance.getBodyType());
      }
    }

    /**
     * Initializes the value for the {@link DialobStore.EmptyCommand#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(DialobDocument.DocumentType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.EmptyCommand#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.EmptyCommand#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEmptyCommand ImmutableEmptyCommand}.
     * @return An immutable instance of EmptyCommand
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEmptyCommand build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEmptyCommand(bodyType, id, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build EmptyCommand, some of required attributes are not set " + attributes;
    }
  }
}
