package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.CreateComposerRelease}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateComposerRelease.builder()}.
 */
@Generated(from = "DialobComposer.CreateComposerRelease", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateComposerRelease
    implements DialobComposer.CreateComposerRelease {
  private final String name;
  private final String description;

  private ImmutableCreateComposerRelease(String name, String description) {
    this.name = name;
    this.description = description;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.CreateComposerRelease#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateComposerRelease withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCreateComposerRelease(newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.CreateComposerRelease#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateComposerRelease withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableCreateComposerRelease(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateComposerRelease} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateComposerRelease
        && equalTo((ImmutableCreateComposerRelease) another);
  }

  private boolean equalTo(ImmutableCreateComposerRelease another) {
    return name.equals(another.name)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateComposerRelease} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateComposerRelease")
        .omitNullValues()
        .add("name", name)
        .add("description", description)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.CreateComposerRelease", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.CreateComposerRelease {
    @Nullable String name;
    @Nullable String description;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateComposerRelease fromJson(Json json) {
    ImmutableCreateComposerRelease.Builder builder = ImmutableCreateComposerRelease.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.CreateComposerRelease} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateComposerRelease instance
   */
  public static ImmutableCreateComposerRelease copyOf(DialobComposer.CreateComposerRelease instance) {
    if (instance instanceof ImmutableCreateComposerRelease) {
      return (ImmutableCreateComposerRelease) instance;
    }
    return ImmutableCreateComposerRelease.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateComposerRelease ImmutableCreateComposerRelease}.
   * <pre>
   * ImmutableCreateComposerRelease.builder()
   *    .name(String) // required {@link DialobComposer.CreateComposerRelease#getName() name}
   *    .description(String) // required {@link DialobComposer.CreateComposerRelease#getDescription() description}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateComposerRelease builder
   */
  public static ImmutableCreateComposerRelease.Builder builder() {
    return new ImmutableCreateComposerRelease.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateComposerRelease ImmutableCreateComposerRelease}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.CreateComposerRelease", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DESCRIPTION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateComposerRelease} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.CreateComposerRelease instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      description(instance.getDescription());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.CreateComposerRelease#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.CreateComposerRelease#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateComposerRelease ImmutableCreateComposerRelease}.
     * @return An immutable instance of CreateComposerRelease
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateComposerRelease build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateComposerRelease(name, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build CreateComposerRelease, some of required attributes are not set " + attributes;
    }
  }
}
