package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.Form;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.Create}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreate.builder()}.
 */
@Generated(from = "DialobComposer.Create", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreate implements DialobComposer.Create {
  private final Form body;

  private ImmutableCreate(Form body) {
    this.body = body;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public Form getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.Create#getBody() body} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreate withBody(Form value) {
    if (this.body == value) return this;
    Form newValue = Objects.requireNonNull(value, "body");
    return new ImmutableCreate(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreate
        && equalTo((ImmutableCreate) another);
  }

  private boolean equalTo(ImmutableCreate another) {
    return body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Create} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Create")
        .omitNullValues()
        .add("body", body)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.Create", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.Create {
    @Nullable Form body;
    @JsonProperty("body")
    public void setBody(Form body) {
      this.body = body;
    }
    @Override
    public Form getBody() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreate fromJson(Json json) {
    ImmutableCreate.Builder builder = ImmutableCreate.builder();
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.Create} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Create instance
   */
  public static ImmutableCreate copyOf(DialobComposer.Create instance) {
    if (instance instanceof ImmutableCreate) {
      return (ImmutableCreate) instance;
    }
    return ImmutableCreate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreate ImmutableCreate}.
   * <pre>
   * ImmutableCreate.builder()
   *    .body(io.dialob.api.form.Form) // required {@link DialobComposer.Create#getBody() body}
   *    .build();
   * </pre>
   * @return A new ImmutableCreate builder
   */
  public static ImmutableCreate.Builder builder() {
    return new ImmutableCreate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreate ImmutableCreate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.Create", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BODY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Form body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Create} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.Create instance) {
      Objects.requireNonNull(instance, "instance");
      body(instance.getBody());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.Create#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    public final Builder body(Form body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreate ImmutableCreate}.
     * @return An immutable instance of Create
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreate(body);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      return "Cannot build Create, some of required attributes are not set " + attributes;
    }
  }
}
