package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.ComposerState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposerState.builder()}.
 */
@Generated(from = "DialobComposer.ComposerState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComposerState implements DialobComposer.ComposerState {
  private final ImmutableMap<String, DialobDocument.FormDocument> forms;
  private final ImmutableMap<String, DialobDocument.FormRevisionDocument> revs;
  private final ImmutableMap<String, DialobDocument.FormReleaseDocument> releases;

  private ImmutableComposerState(
      ImmutableMap<String, DialobDocument.FormDocument> forms,
      ImmutableMap<String, DialobDocument.FormRevisionDocument> revs,
      ImmutableMap<String, DialobDocument.FormReleaseDocument> releases) {
    this.forms = forms;
    this.revs = revs;
    this.releases = releases;
  }

  /**
   * @return The value of the {@code forms} attribute
   */
  @JsonProperty("forms")
  @Override
  public ImmutableMap<String, DialobDocument.FormDocument> getForms() {
    return forms;
  }

  /**
   * @return The value of the {@code revs} attribute
   */
  @JsonProperty("revs")
  @Override
  public ImmutableMap<String, DialobDocument.FormRevisionDocument> getRevs() {
    return revs;
  }

  /**
   * @return The value of the {@code releases} attribute
   */
  @JsonProperty("releases")
  @Override
  public ImmutableMap<String, DialobDocument.FormReleaseDocument> getReleases() {
    return releases;
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobComposer.ComposerState#getForms() forms} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the forms map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerState withForms(Map<String, ? extends DialobDocument.FormDocument> entries) {
    if (this.forms == entries) return this;
    ImmutableMap<String, DialobDocument.FormDocument> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableComposerState(newValue, this.revs, this.releases);
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobComposer.ComposerState#getRevs() revs} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the revs map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerState withRevs(Map<String, ? extends DialobDocument.FormRevisionDocument> entries) {
    if (this.revs == entries) return this;
    ImmutableMap<String, DialobDocument.FormRevisionDocument> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableComposerState(this.forms, newValue, this.releases);
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobComposer.ComposerState#getReleases() releases} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the releases map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerState withReleases(Map<String, ? extends DialobDocument.FormReleaseDocument> entries) {
    if (this.releases == entries) return this;
    ImmutableMap<String, DialobDocument.FormReleaseDocument> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableComposerState(this.forms, this.revs, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposerState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposerState
        && equalTo((ImmutableComposerState) another);
  }

  private boolean equalTo(ImmutableComposerState another) {
    return forms.equals(another.forms)
        && revs.equals(another.revs)
        && releases.equals(another.releases);
  }

  /**
   * Computes a hash code from attributes: {@code forms}, {@code revs}, {@code releases}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + forms.hashCode();
    h += (h << 5) + revs.hashCode();
    h += (h << 5) + releases.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposerState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ComposerState")
        .omitNullValues()
        .add("forms", forms)
        .add("revs", revs)
        .add("releases", releases)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.ComposerState", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.ComposerState {
    @Nullable Map<String, DialobDocument.FormDocument> forms = ImmutableMap.of();
    @Nullable Map<String, DialobDocument.FormRevisionDocument> revs = ImmutableMap.of();
    @Nullable Map<String, DialobDocument.FormReleaseDocument> releases = ImmutableMap.of();
    @JsonProperty("forms")
    public void setForms(Map<String, DialobDocument.FormDocument> forms) {
      this.forms = forms;
    }
    @JsonProperty("revs")
    public void setRevs(Map<String, DialobDocument.FormRevisionDocument> revs) {
      this.revs = revs;
    }
    @JsonProperty("releases")
    public void setReleases(Map<String, DialobDocument.FormReleaseDocument> releases) {
      this.releases = releases;
    }
    @Override
    public Map<String, DialobDocument.FormDocument> getForms() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, DialobDocument.FormRevisionDocument> getRevs() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, DialobDocument.FormReleaseDocument> getReleases() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComposerState fromJson(Json json) {
    ImmutableComposerState.Builder builder = ImmutableComposerState.builder();
    if (json.forms != null) {
      builder.putAllForms(json.forms);
    }
    if (json.revs != null) {
      builder.putAllRevs(json.revs);
    }
    if (json.releases != null) {
      builder.putAllReleases(json.releases);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.ComposerState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComposerState instance
   */
  public static ImmutableComposerState copyOf(DialobComposer.ComposerState instance) {
    if (instance instanceof ImmutableComposerState) {
      return (ImmutableComposerState) instance;
    }
    return ImmutableComposerState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposerState ImmutableComposerState}.
   * <pre>
   * ImmutableComposerState.builder()
   *    .putForms|putAllForms(String =&gt; io.dialob.client.api.DialobDocument.FormDocument) // {@link DialobComposer.ComposerState#getForms() forms} mappings
   *    .putRevs|putAllRevs(String =&gt; io.dialob.client.api.DialobDocument.FormRevisionDocument) // {@link DialobComposer.ComposerState#getRevs() revs} mappings
   *    .putReleases|putAllReleases(String =&gt; io.dialob.client.api.DialobDocument.FormReleaseDocument) // {@link DialobComposer.ComposerState#getReleases() releases} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableComposerState builder
   */
  public static ImmutableComposerState.Builder builder() {
    return new ImmutableComposerState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComposerState ImmutableComposerState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.ComposerState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, DialobDocument.FormDocument> forms = ImmutableMap.builder();
    private ImmutableMap.Builder<String, DialobDocument.FormRevisionDocument> revs = ImmutableMap.builder();
    private ImmutableMap.Builder<String, DialobDocument.FormReleaseDocument> releases = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposerState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.ComposerState instance) {
      Objects.requireNonNull(instance, "instance");
      putAllForms(instance.getForms());
      putAllRevs(instance.getRevs());
      putAllReleases(instance.getReleases());
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getForms() forms} map.
     * @param key The key in the forms map
     * @param value The associated value in the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putForms(String key, DialobDocument.FormDocument value) {
      this.forms.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getForms() forms} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putForms(Map.Entry<String, ? extends DialobDocument.FormDocument> entry) {
      this.forms.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobComposer.ComposerState#getForms() forms} map. Nulls are not permitted
     * @param entries The entries that will be added to the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("forms")
    public final Builder forms(Map<String, ? extends DialobDocument.FormDocument> entries) {
      this.forms = ImmutableMap.builder();
      return putAllForms(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobComposer.ComposerState#getForms() forms} map. Nulls are not permitted
     * @param entries The entries that will be added to the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllForms(Map<String, ? extends DialobDocument.FormDocument> entries) {
      this.forms.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getRevs() revs} map.
     * @param key The key in the revs map
     * @param value The associated value in the revs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRevs(String key, DialobDocument.FormRevisionDocument value) {
      this.revs.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getRevs() revs} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putRevs(Map.Entry<String, ? extends DialobDocument.FormRevisionDocument> entry) {
      this.revs.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobComposer.ComposerState#getRevs() revs} map. Nulls are not permitted
     * @param entries The entries that will be added to the revs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revs")
    public final Builder revs(Map<String, ? extends DialobDocument.FormRevisionDocument> entries) {
      this.revs = ImmutableMap.builder();
      return putAllRevs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobComposer.ComposerState#getRevs() revs} map. Nulls are not permitted
     * @param entries The entries that will be added to the revs map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllRevs(Map<String, ? extends DialobDocument.FormRevisionDocument> entries) {
      this.revs.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getReleases() releases} map.
     * @param key The key in the releases map
     * @param value The associated value in the releases map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putReleases(String key, DialobDocument.FormReleaseDocument value) {
      this.releases.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getReleases() releases} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putReleases(Map.Entry<String, ? extends DialobDocument.FormReleaseDocument> entry) {
      this.releases.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobComposer.ComposerState#getReleases() releases} map. Nulls are not permitted
     * @param entries The entries that will be added to the releases map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("releases")
    public final Builder releases(Map<String, ? extends DialobDocument.FormReleaseDocument> entries) {
      this.releases = ImmutableMap.builder();
      return putAllReleases(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobComposer.ComposerState#getReleases() releases} map. Nulls are not permitted
     * @param entries The entries that will be added to the releases map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllReleases(Map<String, ? extends DialobDocument.FormReleaseDocument> entries) {
      this.releases.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposerState ImmutableComposerState}.
     * @return An immutable instance of ComposerState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposerState build() {
      return new ImmutableComposerState(forms.build(), revs.build(), releases.build());
    }
  }
}
