package io.dialob.client.spi.event;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireClientConnectedEvent.builder()}.
 */
@Generated(from = "QuestionnaireEvent.QuestionnaireClientConnectedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableQuestionnaireClientConnectedEvent
    implements QuestionnaireEvent.QuestionnaireClientConnectedEvent {
  private final String questionnaireId;
  private final InetAddress client;

  private ImmutableQuestionnaireClientConnectedEvent(String questionnaireId, InetAddress client) {
    this.questionnaireId = questionnaireId;
    this.client = client;
  }

  /**
   * @return questionnaire id of event
   */
  @Override
  public String getQuestionnaireId() {
    return questionnaireId;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public InetAddress getClient() {
    return client;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent#getQuestionnaireId() questionnaireId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for questionnaireId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientConnectedEvent withQuestionnaireId(String value) {
    String newValue = Objects.requireNonNull(value, "questionnaireId");
    if (this.questionnaireId.equals(newValue)) return this;
    return new ImmutableQuestionnaireClientConnectedEvent(newValue, this.client);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireClientConnectedEvent withClient(InetAddress value) {
    if (this.client == value) return this;
    InetAddress newValue = Objects.requireNonNull(value, "client");
    return new ImmutableQuestionnaireClientConnectedEvent(this.questionnaireId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireClientConnectedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireClientConnectedEvent
        && equalTo((ImmutableQuestionnaireClientConnectedEvent) another);
  }

  private boolean equalTo(ImmutableQuestionnaireClientConnectedEvent another) {
    return questionnaireId.equals(another.questionnaireId)
        && client.equals(another.client);
  }

  /**
   * Computes a hash code from attributes: {@code questionnaireId}, {@code client}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + questionnaireId.hashCode();
    h += (h << 5) + client.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuestionnaireClientConnectedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QuestionnaireClientConnectedEvent")
        .omitNullValues()
        .add("questionnaireId", questionnaireId)
        .add("client", client)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuestionnaireClientConnectedEvent instance
   */
  public static ImmutableQuestionnaireClientConnectedEvent copyOf(QuestionnaireEvent.QuestionnaireClientConnectedEvent instance) {
    if (instance instanceof ImmutableQuestionnaireClientConnectedEvent) {
      return (ImmutableQuestionnaireClientConnectedEvent) instance;
    }
    return ImmutableQuestionnaireClientConnectedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireClientConnectedEvent ImmutableQuestionnaireClientConnectedEvent}.
   * <pre>
   * ImmutableQuestionnaireClientConnectedEvent.builder()
   *    .questionnaireId(String) // required {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent#getQuestionnaireId() questionnaireId}
   *    .client(java.net.InetAddress) // required {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent#getClient() client}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireClientConnectedEvent builder
   */
  public static ImmutableQuestionnaireClientConnectedEvent.Builder builder() {
    return new ImmutableQuestionnaireClientConnectedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireClientConnectedEvent ImmutableQuestionnaireClientConnectedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuestionnaireEvent.QuestionnaireClientConnectedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUESTIONNAIRE_ID = 0x1L;
    private static final long INIT_BIT_CLIENT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String questionnaireId;
    private @Nullable InetAddress client;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.QuestionnaireEvent.QuestionnaireClientConnectedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QuestionnaireEvent.QuestionnaireClientConnectedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof QuestionnaireEvent) {
        QuestionnaireEvent instance = (QuestionnaireEvent) object;
        questionnaireId(instance.getQuestionnaireId());
      }
      if (object instanceof QuestionnaireEvent.QuestionnaireClientConnectedEvent) {
        QuestionnaireEvent.QuestionnaireClientConnectedEvent instance = (QuestionnaireEvent.QuestionnaireClientConnectedEvent) object;
        client(instance.getClient());
      }
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent#getQuestionnaireId() questionnaireId} attribute.
     * @param questionnaireId The value for questionnaireId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder questionnaireId(String questionnaireId) {
      this.questionnaireId = Objects.requireNonNull(questionnaireId, "questionnaireId");
      initBits &= ~INIT_BIT_QUESTIONNAIRE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link QuestionnaireEvent.QuestionnaireClientConnectedEvent#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder client(InetAddress client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireClientConnectedEvent ImmutableQuestionnaireClientConnectedEvent}.
     * @return An immutable instance of QuestionnaireClientConnectedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireClientConnectedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuestionnaireClientConnectedEvent(questionnaireId, client);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_QUESTIONNAIRE_ID) != 0) attributes.add("questionnaireId");
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      return "Cannot build QuestionnaireClientConnectedEvent, some of required attributes are not set " + attributes;
    }
  }
}
