package io.dialob.client.spi.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DistributedEvent.FormUpdatedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormUpdatedEvent.builder()}.
 */
@Generated(from = "DistributedEvent.FormUpdatedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormUpdatedEvent
    implements DistributedEvent.FormUpdatedEvent {
  private final String formId;
  private final String source;
  private final String revision;

  private ImmutableFormUpdatedEvent(String formId, String source, String revision) {
    this.formId = formId;
    this.source = source;
    this.revision = revision;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * @return The value of the {@code revision} attribute
   */
  @JsonProperty("revision")
  @Override
  public String getRevision() {
    return revision;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormUpdatedEvent#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormUpdatedEvent(newValue, this.source, this.revision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormUpdatedEvent#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableFormUpdatedEvent(this.formId, newValue, this.revision);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormUpdatedEvent#getRevision() revision} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormUpdatedEvent withRevision(String value) {
    String newValue = Objects.requireNonNull(value, "revision");
    if (this.revision.equals(newValue)) return this;
    return new ImmutableFormUpdatedEvent(this.formId, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormUpdatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormUpdatedEvent
        && equalTo((ImmutableFormUpdatedEvent) another);
  }

  private boolean equalTo(ImmutableFormUpdatedEvent another) {
    return formId.equals(another.formId)
        && source.equals(another.source)
        && revision.equals(another.revision);
  }

  /**
   * Computes a hash code from attributes: {@code formId}, {@code source}, {@code revision}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + revision.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormUpdatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormUpdatedEvent")
        .omitNullValues()
        .add("formId", formId)
        .add("source", source)
        .add("revision", revision)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DistributedEvent.FormUpdatedEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DistributedEvent.FormUpdatedEvent {
    @Nullable String formId;
    @Nullable String source;
    @Nullable String revision;
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("source")
    public void setSource(String source) {
      this.source = source;
    }
    @JsonProperty("revision")
    public void setRevision(String revision) {
      this.revision = revision;
    }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
    @Override
    public String getRevision() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormUpdatedEvent fromJson(Json json) {
    ImmutableFormUpdatedEvent.Builder builder = ImmutableFormUpdatedEvent.builder();
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    if (json.revision != null) {
      builder.revision(json.revision);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DistributedEvent.FormUpdatedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormUpdatedEvent instance
   */
  public static ImmutableFormUpdatedEvent copyOf(DistributedEvent.FormUpdatedEvent instance) {
    if (instance instanceof ImmutableFormUpdatedEvent) {
      return (ImmutableFormUpdatedEvent) instance;
    }
    return ImmutableFormUpdatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormUpdatedEvent ImmutableFormUpdatedEvent}.
   * <pre>
   * ImmutableFormUpdatedEvent.builder()
   *    .formId(String) // required {@link DistributedEvent.FormUpdatedEvent#getFormId() formId}
   *    .source(String) // required {@link DistributedEvent.FormUpdatedEvent#getSource() source}
   *    .revision(String) // required {@link DistributedEvent.FormUpdatedEvent#getRevision() revision}
   *    .build();
   * </pre>
   * @return A new ImmutableFormUpdatedEvent builder
   */
  public static ImmutableFormUpdatedEvent.Builder builder() {
    return new ImmutableFormUpdatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormUpdatedEvent ImmutableFormUpdatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DistributedEvent.FormUpdatedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM_ID = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private static final long INIT_BIT_REVISION = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String formId;
    private @Nullable String source;
    private @Nullable String revision;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent.FormUpdatedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent.FormUpdatedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent.FormEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent.FormEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DistributedEvent) {
        DistributedEvent instance = (DistributedEvent) object;
        source(instance.getSource());
      }
      if (object instanceof DistributedEvent.FormUpdatedEvent) {
        DistributedEvent.FormUpdatedEvent instance = (DistributedEvent.FormUpdatedEvent) object;
        revision(instance.getRevision());
      }
      if (object instanceof DistributedEvent.FormEvent) {
        DistributedEvent.FormEvent instance = (DistributedEvent.FormEvent) object;
        formId(instance.getFormId());
      }
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormUpdatedEvent#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormUpdatedEvent#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormUpdatedEvent#getRevision() revision} attribute.
     * @param revision The value for revision 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("revision")
    public final Builder revision(String revision) {
      this.revision = Objects.requireNonNull(revision, "revision");
      initBits &= ~INIT_BIT_REVISION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormUpdatedEvent ImmutableFormUpdatedEvent}.
     * @return An immutable instance of FormUpdatedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormUpdatedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormUpdatedEvent(formId, source, revision);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_REVISION) != 0) attributes.add("revision");
      return "Cannot build FormUpdatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
