package io.dialob.client.spi.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DistributedEvent.FormDeletedEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormDeletedEvent.builder()}.
 */
@Generated(from = "DistributedEvent.FormDeletedEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormDeletedEvent
    implements DistributedEvent.FormDeletedEvent {
  private final String formId;
  private final String source;

  private ImmutableFormDeletedEvent(String formId, String source) {
    this.formId = formId;
    this.source = source;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormDeletedEvent#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDeletedEvent withFormId(String value) {
    String newValue = Objects.requireNonNull(value, "formId");
    if (this.formId.equals(newValue)) return this;
    return new ImmutableFormDeletedEvent(newValue, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DistributedEvent.FormDeletedEvent#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormDeletedEvent withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableFormDeletedEvent(this.formId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormDeletedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormDeletedEvent
        && equalTo((ImmutableFormDeletedEvent) another);
  }

  private boolean equalTo(ImmutableFormDeletedEvent another) {
    return formId.equals(another.formId)
        && source.equals(another.source);
  }

  /**
   * Computes a hash code from attributes: {@code formId}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + formId.hashCode();
    h += (h << 5) + source.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormDeletedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormDeletedEvent")
        .omitNullValues()
        .add("formId", formId)
        .add("source", source)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DistributedEvent.FormDeletedEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DistributedEvent.FormDeletedEvent {
    @Nullable String formId;
    @Nullable String source;
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("source")
    public void setSource(String source) {
      this.source = source;
    }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormDeletedEvent fromJson(Json json) {
    ImmutableFormDeletedEvent.Builder builder = ImmutableFormDeletedEvent.builder();
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DistributedEvent.FormDeletedEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormDeletedEvent instance
   */
  public static ImmutableFormDeletedEvent copyOf(DistributedEvent.FormDeletedEvent instance) {
    if (instance instanceof ImmutableFormDeletedEvent) {
      return (ImmutableFormDeletedEvent) instance;
    }
    return ImmutableFormDeletedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormDeletedEvent ImmutableFormDeletedEvent}.
   * <pre>
   * ImmutableFormDeletedEvent.builder()
   *    .formId(String) // required {@link DistributedEvent.FormDeletedEvent#getFormId() formId}
   *    .source(String) // required {@link DistributedEvent.FormDeletedEvent#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableFormDeletedEvent builder
   */
  public static ImmutableFormDeletedEvent.Builder builder() {
    return new ImmutableFormDeletedEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormDeletedEvent ImmutableFormDeletedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DistributedEvent.FormDeletedEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM_ID = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String formId;
    private @Nullable String source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent.FormEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent.FormEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.spi.event.DistributedEvent.FormDeletedEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DistributedEvent.FormDeletedEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DistributedEvent) {
        DistributedEvent instance = (DistributedEvent) object;
        source(instance.getSource());
      }
      if (object instanceof DistributedEvent.FormEvent) {
        DistributedEvent.FormEvent instance = (DistributedEvent.FormEvent) object;
        formId(instance.getFormId());
      }
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormDeletedEvent#getFormId() formId} attribute.
     * @param formId The value for formId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = Objects.requireNonNull(formId, "formId");
      initBits &= ~INIT_BIT_FORM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DistributedEvent.FormDeletedEvent#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormDeletedEvent ImmutableFormDeletedEvent}.
     * @return An immutable instance of FormDeletedEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormDeletedEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormDeletedEvent(formId, source);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM_ID) != 0) attributes.add("formId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build FormDeletedEvent, some of required attributes are not set " + attributes;
    }
  }
}
