package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.FormEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.Update}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdate.builder()}.
 */
@Generated(from = "DialobComposer.Update", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdate implements DialobComposer.Update {
  private final String id;
  private final String rev;
  private final FormEntity formEntity;

  private ImmutableUpdate(String id, String rev, FormEntity formEntity) {
    this.id = id;
    this.rev = rev;
    this.formEntity = formEntity;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code formEntity} attribute
   */
  @JsonProperty("formEntity")
  @Override
  public FormEntity getFormEntity() {
    return formEntity;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.Update#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdate withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUpdate(newValue, this.rev, this.formEntity);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.Update#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdate withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableUpdate(this.id, newValue, this.formEntity);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.Update#getFormEntity() formEntity} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formEntity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdate withFormEntity(FormEntity value) {
    if (this.formEntity == value) return this;
    FormEntity newValue = Objects.requireNonNull(value, "formEntity");
    return new ImmutableUpdate(this.id, this.rev, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdate
        && equalTo((ImmutableUpdate) another);
  }

  private boolean equalTo(ImmutableUpdate another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && formEntity.equals(another.formEntity);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code formEntity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + formEntity.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Update} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Update")
        .omitNullValues()
        .add("id", id)
        .add("rev", rev)
        .add("formEntity", formEntity)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.Update", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.Update {
    @Nullable String id;
    @Nullable String rev;
    @Nullable FormEntity formEntity;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("formEntity")
    public void setFormEntity(FormEntity formEntity) {
      this.formEntity = formEntity;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public FormEntity getFormEntity() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUpdate fromJson(Json json) {
    ImmutableUpdate.Builder builder = ImmutableUpdate.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.formEntity != null) {
      builder.formEntity(json.formEntity);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.Update} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Update instance
   */
  public static ImmutableUpdate copyOf(DialobComposer.Update instance) {
    if (instance instanceof ImmutableUpdate) {
      return (ImmutableUpdate) instance;
    }
    return ImmutableUpdate.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdate ImmutableUpdate}.
   * <pre>
   * ImmutableUpdate.builder()
   *    .id(String) // required {@link DialobComposer.Update#getId() id}
   *    .rev(String) // required {@link DialobComposer.Update#getRev() rev}
   *    .formEntity(io.dialob.api.form.FormEntity) // required {@link DialobComposer.Update#getFormEntity() formEntity}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdate builder
   */
  public static ImmutableUpdate.Builder builder() {
    return new ImmutableUpdate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdate ImmutableUpdate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.Update", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_FORM_ENTITY = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable FormEntity formEntity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Update} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.Update instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      formEntity(instance.getFormEntity());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.Update#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.Update#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.Update#getFormEntity() formEntity} attribute.
     * @param formEntity The value for formEntity 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("formEntity")
    public final Builder formEntity(FormEntity formEntity) {
      this.formEntity = Objects.requireNonNull(formEntity, "formEntity");
      initBits &= ~INIT_BIT_FORM_ENTITY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdate ImmutableUpdate}.
     * @return An immutable instance of Update
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdate(id, rev, formEntity);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_FORM_ENTITY) != 0) attributes.add("formEntity");
      return "Cannot build Update, some of required attributes are not set " + attributes;
    }
  }
}
