package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.StoreState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStoreState.builder()}.
 */
@Generated(from = "DialobStore.StoreState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStoreState implements DialobStore.StoreState {
  private final ImmutableMap<String, DialobStore.StoreEntity> tags;
  private final ImmutableMap<String, DialobStore.StoreEntity> forms;

  private ImmutableStoreState(
      ImmutableMap<String, DialobStore.StoreEntity> tags,
      ImmutableMap<String, DialobStore.StoreEntity> forms) {
    this.tags = tags;
    this.forms = forms;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public ImmutableMap<String, DialobStore.StoreEntity> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code forms} attribute
   */
  @JsonProperty("forms")
  @Override
  public ImmutableMap<String, DialobStore.StoreEntity> getForms() {
    return forms;
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobStore.StoreState#getTags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStoreState withTags(Map<String, ? extends DialobStore.StoreEntity> entries) {
    if (this.tags == entries) return this;
    ImmutableMap<String, DialobStore.StoreEntity> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableStoreState(newValue, this.forms);
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobStore.StoreState#getForms() forms} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the forms map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStoreState withForms(Map<String, ? extends DialobStore.StoreEntity> entries) {
    if (this.forms == entries) return this;
    ImmutableMap<String, DialobStore.StoreEntity> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableStoreState(this.tags, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStoreState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStoreState
        && equalTo((ImmutableStoreState) another);
  }

  private boolean equalTo(ImmutableStoreState another) {
    return tags.equals(another.tags)
        && forms.equals(another.forms);
  }

  /**
   * Computes a hash code from attributes: {@code tags}, {@code forms}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + forms.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StoreState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StoreState")
        .omitNullValues()
        .add("tags", tags)
        .add("forms", forms)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.StoreState", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.StoreState {
    @Nullable Map<String, DialobStore.StoreEntity> tags = ImmutableMap.of();
    @Nullable Map<String, DialobStore.StoreEntity> forms = ImmutableMap.of();
    @JsonProperty("tags")
    public void setTags(Map<String, DialobStore.StoreEntity> tags) {
      this.tags = tags;
    }
    @JsonProperty("forms")
    public void setForms(Map<String, DialobStore.StoreEntity> forms) {
      this.forms = forms;
    }
    @Override
    public Map<String, DialobStore.StoreEntity> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, DialobStore.StoreEntity> getForms() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStoreState fromJson(Json json) {
    ImmutableStoreState.Builder builder = ImmutableStoreState.builder();
    if (json.tags != null) {
      builder.putAllTags(json.tags);
    }
    if (json.forms != null) {
      builder.putAllForms(json.forms);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.StoreState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StoreState instance
   */
  public static ImmutableStoreState copyOf(DialobStore.StoreState instance) {
    if (instance instanceof ImmutableStoreState) {
      return (ImmutableStoreState) instance;
    }
    return ImmutableStoreState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStoreState ImmutableStoreState}.
   * <pre>
   * ImmutableStoreState.builder()
   *    .putTags|putAllTags(String =&gt; io.dialob.client.api.DialobStore.StoreEntity) // {@link DialobStore.StoreState#getTags() tags} mappings
   *    .putForms|putAllForms(String =&gt; io.dialob.client.api.DialobStore.StoreEntity) // {@link DialobStore.StoreState#getForms() forms} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableStoreState builder
   */
  public static ImmutableStoreState.Builder builder() {
    return new ImmutableStoreState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStoreState ImmutableStoreState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.StoreState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, DialobStore.StoreEntity> tags = ImmutableMap.builder();
    private ImmutableMap.Builder<String, DialobStore.StoreEntity> forms = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StoreState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreState instance) {
      Objects.requireNonNull(instance, "instance");
      putAllTags(instance.getTags());
      putAllForms(instance.getForms());
      return this;
    }

    /**
     * Put one entry to the {@link DialobStore.StoreState#getTags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(String key, DialobStore.StoreEntity value) {
      this.tags.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobStore.StoreState#getTags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(Map.Entry<String, ? extends DialobStore.StoreEntity> entry) {
      this.tags.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobStore.StoreState#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tags")
    public final Builder tags(Map<String, ? extends DialobStore.StoreEntity> entries) {
      this.tags = ImmutableMap.builder();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobStore.StoreState#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTags(Map<String, ? extends DialobStore.StoreEntity> entries) {
      this.tags.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link DialobStore.StoreState#getForms() forms} map.
     * @param key The key in the forms map
     * @param value The associated value in the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putForms(String key, DialobStore.StoreEntity value) {
      this.forms.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobStore.StoreState#getForms() forms} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putForms(Map.Entry<String, ? extends DialobStore.StoreEntity> entry) {
      this.forms.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobStore.StoreState#getForms() forms} map. Nulls are not permitted
     * @param entries The entries that will be added to the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("forms")
    public final Builder forms(Map<String, ? extends DialobStore.StoreEntity> entries) {
      this.forms = ImmutableMap.builder();
      return putAllForms(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobStore.StoreState#getForms() forms} map. Nulls are not permitted
     * @param entries The entries that will be added to the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllForms(Map<String, ? extends DialobStore.StoreEntity> entries) {
      this.forms.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStoreState ImmutableStoreState}.
     * @return An immutable instance of StoreState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStoreState build() {
      return new ImmutableStoreState(tags.build(), forms.build());
    }
  }
}
