package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.FormEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.StoreDump}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStoreDump.builder()}.
 */
@Generated(from = "DialobComposer.StoreDump", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStoreDump implements DialobComposer.StoreDump {
  private final String id;
  private final ImmutableList<FormEntity> value;

  private ImmutableStoreDump(String id, ImmutableList<FormEntity> value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public ImmutableList<FormEntity> getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.StoreDump#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStoreDump withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableStoreDump(newValue, this.value);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.StoreDump#getValue() value}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStoreDump withValue(FormEntity... elements) {
    ImmutableList<FormEntity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStoreDump(this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.StoreDump#getValue() value}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of value elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStoreDump withValue(Iterable<? extends FormEntity> elements) {
    if (this.value == elements) return this;
    ImmutableList<FormEntity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStoreDump(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStoreDump} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStoreDump
        && equalTo((ImmutableStoreDump) another);
  }

  private boolean equalTo(ImmutableStoreDump another) {
    return id.equals(another.id)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StoreDump} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StoreDump")
        .omitNullValues()
        .add("id", id)
        .add("value", value)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.StoreDump", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.StoreDump {
    @Nullable String id;
    @Nullable List<FormEntity> value = ImmutableList.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("value")
    public void setValue(List<FormEntity> value) {
      this.value = value;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<FormEntity> getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStoreDump fromJson(Json json) {
    ImmutableStoreDump.Builder builder = ImmutableStoreDump.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.value != null) {
      builder.addAllValue(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.StoreDump} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StoreDump instance
   */
  public static ImmutableStoreDump copyOf(DialobComposer.StoreDump instance) {
    if (instance instanceof ImmutableStoreDump) {
      return (ImmutableStoreDump) instance;
    }
    return ImmutableStoreDump.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStoreDump ImmutableStoreDump}.
   * <pre>
   * ImmutableStoreDump.builder()
   *    .id(String) // required {@link DialobComposer.StoreDump#getId() id}
   *    .addValue|addAllValue(io.dialob.api.form.FormEntity) // {@link DialobComposer.StoreDump#getValue() value} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStoreDump builder
   */
  public static ImmutableStoreDump.Builder builder() {
    return new ImmutableStoreDump.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStoreDump ImmutableStoreDump}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.StoreDump", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private ImmutableList.Builder<FormEntity> value = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StoreDump} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.StoreDump instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      addAllValue(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.StoreDump#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link DialobComposer.StoreDump#getValue() value} list.
     * @param element A value element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValue(FormEntity element) {
      this.value.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobComposer.StoreDump#getValue() value} list.
     * @param elements An array of value elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addValue(FormEntity... elements) {
      this.value.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobComposer.StoreDump#getValue() value} list.
     * @param elements An iterable of value elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(Iterable<? extends FormEntity> elements) {
      this.value = ImmutableList.builder();
      return addAllValue(elements);
    }

    /**
     * Adds elements to {@link DialobComposer.StoreDump#getValue() value} list.
     * @param elements An iterable of value elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllValue(Iterable<? extends FormEntity> elements) {
      this.value.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableStoreDump ImmutableStoreDump}.
     * @return An immutable instance of StoreDump
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStoreDump build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStoreDump(id, value.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build StoreDump, some of required attributes are not set " + attributes;
    }
  }
}
