package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.FormEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.HistoryEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHistoryEntity.builder()}.
 */
@Generated(from = "DialobStore.HistoryEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHistoryEntity implements DialobStore.HistoryEntity {
  private final String id;
  private final FormEntity bodyType;
  private final ImmutableList<DialobStore.DetachedEntity> body;

  private ImmutableHistoryEntity(
      String id,
      FormEntity bodyType,
      ImmutableList<DialobStore.DetachedEntity> body) {
    this.id = id;
    this.bodyType = bodyType;
    this.body = body;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public FormEntity getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public ImmutableList<DialobStore.DetachedEntity> getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.HistoryEntity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistoryEntity withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableHistoryEntity(newValue, this.bodyType, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.HistoryEntity#getBodyType() bodyType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHistoryEntity withBodyType(FormEntity value) {
    if (this.bodyType == value) return this;
    FormEntity newValue = Objects.requireNonNull(value, "bodyType");
    return new ImmutableHistoryEntity(this.id, newValue, this.body);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobStore.HistoryEntity#getBody() body}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHistoryEntity withBody(DialobStore.DetachedEntity... elements) {
    ImmutableList<DialobStore.DetachedEntity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableHistoryEntity(this.id, this.bodyType, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobStore.HistoryEntity#getBody() body}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of body elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHistoryEntity withBody(Iterable<? extends DialobStore.DetachedEntity> elements) {
    if (this.body == elements) return this;
    ImmutableList<DialobStore.DetachedEntity> newValue = ImmutableList.copyOf(elements);
    return new ImmutableHistoryEntity(this.id, this.bodyType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHistoryEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHistoryEntity
        && equalTo((ImmutableHistoryEntity) another);
  }

  private boolean equalTo(ImmutableHistoryEntity another) {
    return id.equals(another.id)
        && bodyType.equals(another.bodyType)
        && body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code bodyType}, {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HistoryEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HistoryEntity")
        .omitNullValues()
        .add("id", id)
        .add("bodyType", bodyType)
        .add("body", body)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.HistoryEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.HistoryEntity {
    @Nullable String id;
    @Nullable FormEntity bodyType;
    @Nullable List<DialobStore.DetachedEntity> body = ImmutableList.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("bodyType")
    public void setBodyType(FormEntity bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("body")
    public void setBody(List<DialobStore.DetachedEntity> body) {
      this.body = body;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public FormEntity getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public List<DialobStore.DetachedEntity> getBody() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHistoryEntity fromJson(Json json) {
    ImmutableHistoryEntity.Builder builder = ImmutableHistoryEntity.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.body != null) {
      builder.addAllBody(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.HistoryEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HistoryEntity instance
   */
  public static ImmutableHistoryEntity copyOf(DialobStore.HistoryEntity instance) {
    if (instance instanceof ImmutableHistoryEntity) {
      return (ImmutableHistoryEntity) instance;
    }
    return ImmutableHistoryEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHistoryEntity ImmutableHistoryEntity}.
   * <pre>
   * ImmutableHistoryEntity.builder()
   *    .id(String) // required {@link DialobStore.HistoryEntity#getId() id}
   *    .bodyType(io.dialob.api.form.FormEntity) // required {@link DialobStore.HistoryEntity#getBodyType() bodyType}
   *    .addBody|addAllBody(io.dialob.client.api.DialobStore.DetachedEntity) // {@link DialobStore.HistoryEntity#getBody() body} elements
   *    .build();
   * </pre>
   * @return A new ImmutableHistoryEntity builder
   */
  public static ImmutableHistoryEntity.Builder builder() {
    return new ImmutableHistoryEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHistoryEntity ImmutableHistoryEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.HistoryEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_BODY_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable FormEntity bodyType;
    private ImmutableList.Builder<DialobStore.DetachedEntity> body = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HistoryEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.HistoryEntity instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      bodyType(instance.getBodyType());
      addAllBody(instance.getBody());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.HistoryEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.HistoryEntity#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(FormEntity bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link DialobStore.HistoryEntity#getBody() body} list.
     * @param element A body element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBody(DialobStore.DetachedEntity element) {
      this.body.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobStore.HistoryEntity#getBody() body} list.
     * @param elements An array of body elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBody(DialobStore.DetachedEntity... elements) {
      this.body.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobStore.HistoryEntity#getBody() body} list.
     * @param elements An iterable of body elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    public final Builder body(Iterable<? extends DialobStore.DetachedEntity> elements) {
      this.body = ImmutableList.builder();
      return addAllBody(elements);
    }

    /**
     * Adds elements to {@link DialobStore.HistoryEntity#getBody() body} list.
     * @param elements An iterable of body elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBody(Iterable<? extends DialobStore.DetachedEntity> elements) {
      this.body.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableHistoryEntity ImmutableHistoryEntity}.
     * @return An immutable instance of HistoryEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHistoryEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHistoryEntity(id, bodyType, body.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      return "Cannot build HistoryEntity, some of required attributes are not set " + attributes;
    }
  }
}
