package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.FormAndTags}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormAndTags.builder()}.
 */
@Generated(from = "DialobComposer.FormAndTags", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFormAndTags implements DialobComposer.FormAndTags {
  private final Form form;
  private final ImmutableList<FormTag> tags;

  private ImmutableFormAndTags(
      Form form,
      ImmutableList<FormTag> tags) {
    this.form = form;
    this.tags = tags;
  }

  /**
   * @return The value of the {@code form} attribute
   */
  @JsonProperty("form")
  @Override
  public Form getForm() {
    return form;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public ImmutableList<FormTag> getTags() {
    return tags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.FormAndTags#getForm() form} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for form
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormAndTags withForm(Form value) {
    if (this.form == value) return this;
    Form newValue = Objects.requireNonNull(value, "form");
    return new ImmutableFormAndTags(newValue, this.tags);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.FormAndTags#getTags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormAndTags withTags(FormTag... elements) {
    ImmutableList<FormTag> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormAndTags(this.form, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.FormAndTags#getTags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormAndTags withTags(Iterable<? extends FormTag> elements) {
    if (this.tags == elements) return this;
    ImmutableList<FormTag> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFormAndTags(this.form, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormAndTags} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormAndTags
        && equalTo((ImmutableFormAndTags) another);
  }

  private boolean equalTo(ImmutableFormAndTags another) {
    return form.equals(another.form)
        && tags.equals(another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code form}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + form.hashCode();
    h += (h << 5) + tags.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormAndTags} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FormAndTags")
        .omitNullValues()
        .add("form", form)
        .add("tags", tags)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.FormAndTags", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.FormAndTags {
    @Nullable Form form;
    @Nullable List<FormTag> tags = ImmutableList.of();
    @JsonProperty("form")
    public void setForm(Form form) {
      this.form = form;
    }
    @JsonProperty("tags")
    public void setTags(List<FormTag> tags) {
      this.tags = tags;
    }
    @Override
    public Form getForm() { throw new UnsupportedOperationException(); }
    @Override
    public List<FormTag> getTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormAndTags fromJson(Json json) {
    ImmutableFormAndTags.Builder builder = ImmutableFormAndTags.builder();
    if (json.form != null) {
      builder.form(json.form);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.FormAndTags} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormAndTags instance
   */
  public static ImmutableFormAndTags copyOf(DialobComposer.FormAndTags instance) {
    if (instance instanceof ImmutableFormAndTags) {
      return (ImmutableFormAndTags) instance;
    }
    return ImmutableFormAndTags.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormAndTags ImmutableFormAndTags}.
   * <pre>
   * ImmutableFormAndTags.builder()
   *    .form(io.dialob.api.form.Form) // required {@link DialobComposer.FormAndTags#getForm() form}
   *    .addTags|addAllTags(io.dialob.api.form.FormTag) // {@link DialobComposer.FormAndTags#getTags() tags} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFormAndTags builder
   */
  public static ImmutableFormAndTags.Builder builder() {
    return new ImmutableFormAndTags.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormAndTags ImmutableFormAndTags}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.FormAndTags", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FORM = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Form form;
    private ImmutableList.Builder<FormTag> tags = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormAndTags} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.FormAndTags instance) {
      Objects.requireNonNull(instance, "instance");
      form(instance.getForm());
      addAllTags(instance.getTags());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.FormAndTags#getForm() form} attribute.
     * @param form The value for form 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("form")
    public final Builder form(Form form) {
      this.form = Objects.requireNonNull(form, "form");
      initBits &= ~INIT_BIT_FORM;
      return this;
    }

    /**
     * Adds one element to {@link DialobComposer.FormAndTags#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(FormTag element) {
      this.tags.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobComposer.FormAndTags#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTags(FormTag... elements) {
      this.tags.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobComposer.FormAndTags#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tags")
    public final Builder tags(Iterable<? extends FormTag> elements) {
      this.tags = ImmutableList.builder();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link DialobComposer.FormAndTags#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTags(Iterable<? extends FormTag> elements) {
      this.tags.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormAndTags ImmutableFormAndTags}.
     * @return An immutable instance of FormAndTags
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormAndTags build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFormAndTags(form, tags.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FORM) != 0) attributes.add("form");
      return "Cannot build FormAndTags, some of required attributes are not set " + attributes;
    }
  }
}
