package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.DeleteStoreEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteStoreEntity.builder()}.
 */
@Generated(from = "DialobStore.DeleteStoreEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeleteStoreEntity implements DialobStore.DeleteStoreEntity {
  private final String id;
  private final DialobStore.BodyType type;

  private ImmutableDeleteStoreEntity(String id, DialobStore.BodyType type) {
    this.id = id;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public DialobStore.BodyType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.DeleteStoreEntity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteStoreEntity withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDeleteStoreEntity(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.DeleteStoreEntity#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteStoreEntity withType(DialobStore.BodyType value) {
    if (this.type == value) return this;
    DialobStore.BodyType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableDeleteStoreEntity(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteStoreEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteStoreEntity
        && equalTo((ImmutableDeleteStoreEntity) another);
  }

  private boolean equalTo(ImmutableDeleteStoreEntity another) {
    return id.equals(another.id)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteStoreEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeleteStoreEntity")
        .omitNullValues()
        .add("id", id)
        .add("type", type)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.DeleteStoreEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.DeleteStoreEntity {
    @Nullable String id;
    @Nullable DialobStore.BodyType type;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("type")
    public void setType(DialobStore.BodyType type) {
      this.type = type;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public DialobStore.BodyType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDeleteStoreEntity fromJson(Json json) {
    ImmutableDeleteStoreEntity.Builder builder = ImmutableDeleteStoreEntity.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.DeleteStoreEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteStoreEntity instance
   */
  public static ImmutableDeleteStoreEntity copyOf(DialobStore.DeleteStoreEntity instance) {
    if (instance instanceof ImmutableDeleteStoreEntity) {
      return (ImmutableDeleteStoreEntity) instance;
    }
    return ImmutableDeleteStoreEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteStoreEntity ImmutableDeleteStoreEntity}.
   * <pre>
   * ImmutableDeleteStoreEntity.builder()
   *    .id(String) // required {@link DialobStore.DeleteStoreEntity#getId() id}
   *    .type(io.dialob.client.api.DialobStore.BodyType) // required {@link DialobStore.DeleteStoreEntity#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableDeleteStoreEntity builder
   */
  public static ImmutableDeleteStoreEntity.Builder builder() {
    return new ImmutableDeleteStoreEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteStoreEntity ImmutableDeleteStoreEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.DeleteStoreEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable DialobStore.BodyType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.StoreCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.StoreCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.client.api.DialobStore.DeleteStoreEntity} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.DeleteStoreEntity instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof DialobStore.StoreCommand) {
        DialobStore.StoreCommand instance = (DialobStore.StoreCommand) object;
        type(instance.getType());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link DialobStore.DeleteStoreEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.DeleteStoreEntity#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(DialobStore.BodyType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteStoreEntity ImmutableDeleteStoreEntity}.
     * @return An immutable instance of DeleteStoreEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteStoreEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDeleteStoreEntity(id, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build DeleteStoreEntity, some of required attributes are not set " + attributes;
    }
  }
}
