package io.dialob.client.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CurrentUserSupplier.CurrentUser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCurrentUser.builder()}.
 */
@Generated(from = "CurrentUserSupplier.CurrentUser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCurrentUser implements CurrentUserSupplier.CurrentUser {
  private final String user;
  private final String email;

  private ImmutableCurrentUser(String user, String email) {
    this.user = user;
    this.email = email;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @Override
  public String getUser() {
    return user;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @Override
  public String getEmail() {
    return email;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CurrentUserSupplier.CurrentUser#getUser() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCurrentUser withUser(String value) {
    String newValue = Objects.requireNonNull(value, "user");
    if (this.user.equals(newValue)) return this;
    return new ImmutableCurrentUser(newValue, this.email);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CurrentUserSupplier.CurrentUser#getEmail() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCurrentUser withEmail(String value) {
    String newValue = Objects.requireNonNull(value, "email");
    if (this.email.equals(newValue)) return this;
    return new ImmutableCurrentUser(this.user, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCurrentUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCurrentUser
        && equalTo((ImmutableCurrentUser) another);
  }

  private boolean equalTo(ImmutableCurrentUser another) {
    return user.equals(another.user)
        && email.equals(another.email);
  }

  /**
   * Computes a hash code from attributes: {@code user}, {@code email}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + user.hashCode();
    h += (h << 5) + email.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CurrentUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CurrentUser")
        .omitNullValues()
        .add("user", user)
        .add("email", email)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CurrentUserSupplier.CurrentUser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CurrentUser instance
   */
  public static ImmutableCurrentUser copyOf(CurrentUserSupplier.CurrentUser instance) {
    if (instance instanceof ImmutableCurrentUser) {
      return (ImmutableCurrentUser) instance;
    }
    return ImmutableCurrentUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCurrentUser ImmutableCurrentUser}.
   * <pre>
   * ImmutableCurrentUser.builder()
   *    .user(String) // required {@link CurrentUserSupplier.CurrentUser#getUser() user}
   *    .email(String) // required {@link CurrentUserSupplier.CurrentUser#getEmail() email}
   *    .build();
   * </pre>
   * @return A new ImmutableCurrentUser builder
   */
  public static ImmutableCurrentUser.Builder builder() {
    return new ImmutableCurrentUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCurrentUser ImmutableCurrentUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CurrentUserSupplier.CurrentUser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER = 0x1L;
    private static final long INIT_BIT_EMAIL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String user;
    private @Nullable String email;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CurrentUser} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CurrentUserSupplier.CurrentUser instance) {
      Objects.requireNonNull(instance, "instance");
      user(instance.getUser());
      email(instance.getEmail());
      return this;
    }

    /**
     * Initializes the value for the {@link CurrentUserSupplier.CurrentUser#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder user(String user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Initializes the value for the {@link CurrentUserSupplier.CurrentUser#getEmail() email} attribute.
     * @param email The value for email 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      initBits &= ~INIT_BIT_EMAIL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCurrentUser ImmutableCurrentUser}.
     * @return An immutable instance of CurrentUser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCurrentUser build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCurrentUser(user, email);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
      if ((initBits & INIT_BIT_EMAIL) != 0) attributes.add("email");
      return "Cannot build CurrentUser, some of required attributes are not set " + attributes;
    }
  }
}
