package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.form.FormTag;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.ComposerState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposerState.builder()}.
 */
@Generated(from = "DialobComposer.ComposerState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComposerState implements DialobComposer.ComposerState {
  private final ImmutableMap<String, DialobComposer.ComposerEntity<FormTag>> tags;
  private final ImmutableMap<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> forms;

  private ImmutableComposerState(
      ImmutableMap<String, DialobComposer.ComposerEntity<FormTag>> tags,
      ImmutableMap<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> forms) {
    this.tags = tags;
    this.forms = forms;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public ImmutableMap<String, DialobComposer.ComposerEntity<FormTag>> getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code forms} attribute
   */
  @JsonProperty("forms")
  @Override
  public ImmutableMap<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> getForms() {
    return forms;
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobComposer.ComposerState#getTags() tags} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the tags map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerState withTags(Map<String, ? extends DialobComposer.ComposerEntity<FormTag>> entries) {
    if (this.tags == entries) return this;
    ImmutableMap<String, DialobComposer.ComposerEntity<FormTag>> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableComposerState(newValue, this.forms);
  }

  /**
   * Copy the current immutable object by replacing the {@link DialobComposer.ComposerState#getForms() forms} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the forms map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerState withForms(Map<String, ? extends DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> entries) {
    if (this.forms == entries) return this;
    ImmutableMap<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableComposerState(this.tags, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposerState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposerState
        && equalTo((ImmutableComposerState) another);
  }

  private boolean equalTo(ImmutableComposerState another) {
    return tags.equals(another.tags)
        && forms.equals(another.forms);
  }

  /**
   * Computes a hash code from attributes: {@code tags}, {@code forms}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + forms.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposerState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ComposerState")
        .omitNullValues()
        .add("tags", tags)
        .add("forms", forms)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.ComposerState", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobComposer.ComposerState {
    @Nullable Map<String, DialobComposer.ComposerEntity<FormTag>> tags = ImmutableMap.of();
    @Nullable Map<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> forms = ImmutableMap.of();
    @JsonProperty("tags")
    public void setTags(Map<String, DialobComposer.ComposerEntity<FormTag>> tags) {
      this.tags = tags;
    }
    @JsonProperty("forms")
    public void setForms(Map<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> forms) {
      this.forms = forms;
    }
    @Override
    public Map<String, DialobComposer.ComposerEntity<FormTag>> getTags() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> getForms() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComposerState fromJson(Json json) {
    ImmutableComposerState.Builder builder = ImmutableComposerState.builder();
    if (json.tags != null) {
      builder.putAllTags(json.tags);
    }
    if (json.forms != null) {
      builder.putAllForms(json.forms);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.ComposerState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComposerState instance
   */
  public static ImmutableComposerState copyOf(DialobComposer.ComposerState instance) {
    if (instance instanceof ImmutableComposerState) {
      return (ImmutableComposerState) instance;
    }
    return ImmutableComposerState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposerState ImmutableComposerState}.
   * <pre>
   * ImmutableComposerState.builder()
   *    .putTags|putAllTags(String =&gt; io.dialob.client.api.DialobComposer.ComposerEntity&amp;lt;io.dialob.api.form.FormTag&amp;gt;) // {@link DialobComposer.ComposerState#getTags() tags} mappings
   *    .putForms|putAllForms(String =&gt; io.dialob.client.api.DialobComposer.ComposerEntity&amp;lt;io.dialob.client.api.DialobComposer.FormAndTags&amp;gt;) // {@link DialobComposer.ComposerState#getForms() forms} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableComposerState builder
   */
  public static ImmutableComposerState.Builder builder() {
    return new ImmutableComposerState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComposerState ImmutableComposerState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.ComposerState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableMap.Builder<String, DialobComposer.ComposerEntity<FormTag>> tags = ImmutableMap.builder();
    private ImmutableMap.Builder<String, DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> forms = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposerState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobComposer.ComposerState instance) {
      Objects.requireNonNull(instance, "instance");
      putAllTags(instance.getTags());
      putAllForms(instance.getForms());
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getTags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(String key, DialobComposer.ComposerEntity<FormTag> value) {
      this.tags.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getTags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putTags(Map.Entry<String, ? extends DialobComposer.ComposerEntity<FormTag>> entry) {
      this.tags.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobComposer.ComposerState#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tags")
    public final Builder tags(Map<String, ? extends DialobComposer.ComposerEntity<FormTag>> entries) {
      this.tags = ImmutableMap.builder();
      return putAllTags(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobComposer.ComposerState#getTags() tags} map. Nulls are not permitted
     * @param entries The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllTags(Map<String, ? extends DialobComposer.ComposerEntity<FormTag>> entries) {
      this.tags.putAll(entries);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getForms() forms} map.
     * @param key The key in the forms map
     * @param value The associated value in the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putForms(String key, DialobComposer.ComposerEntity<DialobComposer.FormAndTags> value) {
      this.forms.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DialobComposer.ComposerState#getForms() forms} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putForms(Map.Entry<String, ? extends DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> entry) {
      this.forms.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DialobComposer.ComposerState#getForms() forms} map. Nulls are not permitted
     * @param entries The entries that will be added to the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("forms")
    public final Builder forms(Map<String, ? extends DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> entries) {
      this.forms = ImmutableMap.builder();
      return putAllForms(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DialobComposer.ComposerState#getForms() forms} map. Nulls are not permitted
     * @param entries The entries that will be added to the forms map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllForms(Map<String, ? extends DialobComposer.ComposerEntity<DialobComposer.FormAndTags>> entries) {
      this.forms.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposerState ImmutableComposerState}.
     * @return An immutable instance of ComposerState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposerState build() {
      return new ImmutableComposerState(tags.build(), forms.build());
    }
  }
}
