package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.dialob.api.rest.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobComposer.ComposerEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComposerEntity.builder()}.
 */
@Generated(from = "DialobComposer.ComposerEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableComposerEntity<A> implements DialobComposer.ComposerEntity<A> {
  private final String id;
  private final A body;
  private final ImmutableList<Response> errors;
  private final DialobStore.BodyStatus status;

  private ImmutableComposerEntity(
      String id,
      A body,
      ImmutableList<Response> errors,
      DialobStore.BodyStatus status) {
    this.id = id;
    this.body = body;
    this.errors = errors;
    this.status = status;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public A getBody() {
    return body;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public ImmutableList<Response> getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public DialobStore.BodyStatus getStatus() {
    return status;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerEntity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerEntity<A> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableComposerEntity<>(newValue, this.body, this.errors, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerEntity#getBody() body} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerEntity<A> withBody(A value) {
    if (this.body == value) return this;
    A newValue = Objects.requireNonNull(value, "body");
    return new ImmutableComposerEntity<>(this.id, newValue, this.errors, this.status);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.ComposerEntity#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerEntity<A> withErrors(Response... elements) {
    ImmutableList<Response> newValue = ImmutableList.copyOf(elements);
    return new ImmutableComposerEntity<>(this.id, this.body, newValue, this.status);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DialobComposer.ComposerEntity#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComposerEntity<A> withErrors(Iterable<? extends Response> elements) {
    if (this.errors == elements) return this;
    ImmutableList<Response> newValue = ImmutableList.copyOf(elements);
    return new ImmutableComposerEntity<>(this.id, this.body, newValue, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobComposer.ComposerEntity#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComposerEntity<A> withStatus(DialobStore.BodyStatus value) {
    if (this.status == value) return this;
    DialobStore.BodyStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableComposerEntity<>(this.id, this.body, this.errors, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComposerEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComposerEntity<?>
        && equalTo((ImmutableComposerEntity<?>) another);
  }

  private boolean equalTo(ImmutableComposerEntity<?> another) {
    return id.equals(another.id)
        && body.equals(another.body)
        && errors.equals(another.errors)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code body}, {@code errors}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + body.hashCode();
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComposerEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ComposerEntity")
        .omitNullValues()
        .add("id", id)
        .add("body", body)
        .add("errors", errors)
        .add("status", status)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobComposer.ComposerEntity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<A> implements DialobComposer.ComposerEntity<A> {
    @Nullable String id;
    @Nullable A body;
    @Nullable List<Response> errors = ImmutableList.of();
    @Nullable DialobStore.BodyStatus status;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("body")
    public void setBody(A body) {
      this.body = body;
    }
    @JsonProperty("errors")
    public void setErrors(List<Response> errors) {
      this.errors = errors;
    }
    @JsonProperty("status")
    public void setStatus(DialobStore.BodyStatus status) {
      this.status = status;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public A getBody() { throw new UnsupportedOperationException(); }
    @Override
    public List<Response> getErrors() { throw new UnsupportedOperationException(); }
    @Override
    public DialobStore.BodyStatus getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <A> generic parameter A
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static <A> ImmutableComposerEntity<A> fromJson(Json<A> json) {
    ImmutableComposerEntity.Builder<A> builder = ImmutableComposerEntity.<A>builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobComposer.ComposerEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <A> generic parameter A
   * @param instance The instance to copy
   * @return A copied immutable ComposerEntity instance
   */
  public static <A> ImmutableComposerEntity<A> copyOf(DialobComposer.ComposerEntity<A> instance) {
    if (instance instanceof ImmutableComposerEntity<?>) {
      return (ImmutableComposerEntity<A>) instance;
    }
    return ImmutableComposerEntity.<A>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComposerEntity ImmutableComposerEntity}.
   * <pre>
   * ImmutableComposerEntity.&amp;lt;A&amp;gt;builder()
   *    .id(String) // required {@link DialobComposer.ComposerEntity#getId() id}
   *    .body(A) // required {@link DialobComposer.ComposerEntity#getBody() body}
   *    .addErrors|addAllErrors(io.dialob.api.rest.Response) // {@link DialobComposer.ComposerEntity#getErrors() errors} elements
   *    .status(io.dialob.client.api.DialobStore.BodyStatus) // required {@link DialobComposer.ComposerEntity#getStatus() status}
   *    .build();
   * </pre>
   * @param <A> generic parameter A
   * @return A new ImmutableComposerEntity builder
   */
  public static <A> ImmutableComposerEntity.Builder<A> builder() {
    return new ImmutableComposerEntity.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableComposerEntity ImmutableComposerEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobComposer.ComposerEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<A> {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_BODY = 0x2L;
    private static final long INIT_BIT_STATUS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable A body;
    private ImmutableList.Builder<Response> errors = ImmutableList.builder();
    private @Nullable DialobStore.BodyStatus status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComposerEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A> from(DialobComposer.ComposerEntity<A> instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      body(instance.getBody());
      addAllErrors(instance.getErrors());
      status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder<A> id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerEntity#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    public final Builder<A> body(A body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Adds one element to {@link DialobComposer.ComposerEntity#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A> addErrors(Response element) {
      this.errors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DialobComposer.ComposerEntity#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A> addErrors(Response... elements) {
      this.errors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DialobComposer.ComposerEntity#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("errors")
    public final Builder<A> errors(Iterable<? extends Response> elements) {
      this.errors = ImmutableList.builder();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link DialobComposer.ComposerEntity#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<A> addAllErrors(Iterable<? extends Response> elements) {
      this.errors.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link DialobComposer.ComposerEntity#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("status")
    public final Builder<A> status(DialobStore.BodyStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComposerEntity ImmutableComposerEntity}.
     * @return An immutable instance of ComposerEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComposerEntity<A> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComposerEntity<>(id, body, errors.build(), status);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build ComposerEntity, some of required attributes are not set " + attributes;
    }
  }
}
