package io.dialob.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DialobStore.BodySource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBodySource.builder()}.
 */
@Generated(from = "DialobStore.BodySource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBodySource implements DialobStore.BodySource {
  private final String id;
  private final String hash;
  private final DialobStore.BodyType bodyType;
  private final String value;

  private ImmutableBodySource(
      String id,
      String hash,
      DialobStore.BodyType bodyType,
      String value) {
    this.id = id;
    this.hash = hash;
    this.bodyType = bodyType;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @JsonProperty("bodyType")
  @Override
  public DialobStore.BodyType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.BodySource#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBodySource withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableBodySource(newValue, this.hash, this.bodyType, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.BodySource#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBodySource withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableBodySource(this.id, newValue, this.bodyType, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.BodySource#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBodySource withBodyType(DialobStore.BodyType value) {
    if (this.bodyType == value) return this;
    DialobStore.BodyType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableBodySource(this.id, this.hash, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialobStore.BodySource#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBodySource withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableBodySource(this.id, this.hash, this.bodyType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBodySource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBodySource
        && equalTo((ImmutableBodySource) another);
  }

  private boolean equalTo(ImmutableBodySource another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && bodyType.equals(another.bodyType)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code bodyType}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BodySource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BodySource")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("bodyType", bodyType)
        .add("value", value)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DialobStore.BodySource", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialobStore.BodySource {
    @Nullable String id;
    @Nullable String hash;
    @Nullable DialobStore.BodyType bodyType;
    @Nullable String value;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("bodyType")
    public void setBodyType(DialobStore.BodyType bodyType) {
      this.bodyType = bodyType;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public DialobStore.BodyType getBodyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBodySource fromJson(Json json) {
    ImmutableBodySource.Builder builder = ImmutableBodySource.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.bodyType != null) {
      builder.bodyType(json.bodyType);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialobStore.BodySource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BodySource instance
   */
  public static ImmutableBodySource copyOf(DialobStore.BodySource instance) {
    if (instance instanceof ImmutableBodySource) {
      return (ImmutableBodySource) instance;
    }
    return ImmutableBodySource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBodySource ImmutableBodySource}.
   * <pre>
   * ImmutableBodySource.builder()
   *    .id(String) // required {@link DialobStore.BodySource#getId() id}
   *    .hash(String) // required {@link DialobStore.BodySource#getHash() hash}
   *    .bodyType(io.dialob.client.api.DialobStore.BodyType) // required {@link DialobStore.BodySource#getBodyType() bodyType}
   *    .value(String) // required {@link DialobStore.BodySource#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableBodySource builder
   */
  public static ImmutableBodySource.Builder builder() {
    return new ImmutableBodySource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBodySource ImmutableBodySource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DialobStore.BodySource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_BODY_TYPE = 0x4L;
    private static final long INIT_BIT_VALUE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable DialobStore.BodyType bodyType;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BodySource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DialobStore.BodySource instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      hash(instance.getHash());
      bodyType(instance.getBodyType());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.BodySource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.BodySource#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.BodySource#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bodyType")
    public final Builder bodyType(DialobStore.BodyType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link DialobStore.BodySource#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBodySource ImmutableBodySource}.
     * @return An immutable instance of BodySource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBodySource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBodySource(id, hash, bodyType, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build BodySource, some of required attributes are not set " + attributes;
    }
  }
}
