/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cache;

import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.cache.QuestionnaireSessionCache;
import io.dialob.integration.api.event.FormUpdatedEvent;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.questionnaire.service.api.session.QuestionnaireSessionSaveService;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;

public class ScheduledSessionEvictionPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledSessionEvictionPolicy.class);
    private final Clock clock;
    private final QuestionnaireSessionCache cache;
    private final Optional<QuestionnaireSessionSaveService> sessionService;
    private final Optional<CacheManager> cacheManager;
    private final Integer ttl;

    public ScheduledSessionEvictionPolicy(Clock clock, QuestionnaireSessionCache cache, Optional<QuestionnaireSessionSaveService> sessionService, Optional<CacheManager> cacheManager, Integer ttl) {
        this.clock = clock;
        this.cache = cache;
        this.sessionService = sessionService;
        this.cacheManager = cacheManager;
        this.ttl = ttl != null ? ttl : 60000;
    }

    @Scheduled(fixedRate=2000L)
    public void evictQuietSessions() {
        LOGGER.debug("evictQuietSessions");
        Instant now = this.clock.instant();
        this.evictWhen(session -> session.getStatus() == Questionnaire.Metadata.Status.COMPLETED || Duration.between(session.getLastUpdate(), now).toMillis() > (long)this.ttl.intValue());
    }

    protected void evictWhen(Predicate<QuestionnaireSession> evictCondition) {
        HashSet sessionsToEvict = new HashSet();
        this.cache.forEach(session -> {
            if (evictCondition.test((QuestionnaireSession)session)) {
                session.getSessionId().ifPresent(sessionsToEvict::add);
            }
        });
        sessionsToEvict.stream().forEach(this::evict);
    }

    protected void evict(String sessionId) {
        this.sessionService.ifPresent(questionnaireSessionService -> this.cache.evict(sessionId, arg_0 -> ((QuestionnaireSessionSaveService)questionnaireSessionService).save(arg_0)));
    }

    @EventListener
    protected void onFormUpdatedEvent(FormUpdatedEvent event) {
        LOGGER.debug("onFormUpdatedEvent({})", (Object)event);
        String formId = event.getFormId();
        this.evictWhen(session -> session.usesLastestFormRevision() && formId.equals(session.getFormId()));
        this.cacheManager.flatMap(cacheManager -> Optional.ofNullable(cacheManager.getCache("dialobProgramsCache"))).ifPresent(programCache -> programCache.evict((Object)formId));
    }
}

