/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.cache;

import io.dialob.cache.QuestionnaireSessionCache;
import io.dialob.questionnaire.service.api.session.QuestionnaireSession;
import io.dialob.security.tenant.ImmutableTenant;
import io.dialob.security.tenant.Tenant;
import io.dialob.security.tenant.TenantContextHolderCurrentTenant;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class LocalQuestionnaireSessionCache
implements QuestionnaireSessionCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalQuestionnaireSessionCache.class);
    private final ConcurrentMap<String, QuestionnaireSession> sessionCache = new ConcurrentHashMap<String, QuestionnaireSession>();
    private final String name;

    public LocalQuestionnaireSessionCache(String name) {
        this.name = name;
    }

    @Override
    public int size() {
        return this.sessionCache.size();
    }

    protected Cache.ValueWrapper internalGet(@Nonnull String questionnaireId) {
        QuestionnaireSession session = (QuestionnaireSession)this.sessionCache.get(questionnaireId);
        if (session == null) {
            return null;
        }
        return () -> session;
    }

    @Override
    public synchronized void evict(@Nonnull String sessionId, Function<QuestionnaireSession, QuestionnaireSession> beforeCloseCallback) {
        QuestionnaireSession questionnaireSession = (QuestionnaireSession)this.sessionCache.get(sessionId);
        if (questionnaireSession == null) {
            return;
        }
        if (beforeCloseCallback == null) {
            LOGGER.warn("Evicting session \"{}\" without callback.", (Object)sessionId);
        } else {
            LOGGER.info("Evicting session \"{}\".", (Object)sessionId);
        }
        TenantContextHolderCurrentTenant.runInTenantContext((Tenant)ImmutableTenant.builder().id(questionnaireSession.getTenantId()).name(Optional.empty()).build(), () -> {
            String rev;
            String revAfterCallback = rev = questionnaireSession.getRev();
            QuestionnaireSession questionnaireSessionToEvict = questionnaireSession;
            if (questionnaireSessionToEvict.isActive()) {
                questionnaireSessionToEvict.passivate();
                if (beforeCloseCallback != null) {
                    try {
                        questionnaireSessionToEvict = (QuestionnaireSession)beforeCloseCallback.apply(questionnaireSessionToEvict);
                    }
                    catch (Exception e) {
                        LOGGER.error("Eviction callback failed: {}", (Object)e.getMessage());
                        throw e;
                    }
                    revAfterCallback = questionnaireSessionToEvict.getRev();
                }
            }
            LOGGER.debug("Closing session {}, rev = {}, revAfterCallback = {}", new Object[]{sessionId, rev, revAfterCallback});
            questionnaireSessionToEvict.close();
            if (!this.sessionCache.remove(sessionId, questionnaireSessionToEvict)) {
                LOGGER.warn("Could not evict session {}. New session appeared. rev = {}, revAfterCallback = {}", new Object[]{sessionId, rev, revAfterCallback});
            }
        });
    }

    @Nonnull
    protected QuestionnaireSession put(@Nonnull QuestionnaireSession questionnaireSession) {
        return questionnaireSession.getSessionId().map(sessionId -> {
            LOGGER.debug("Caching session {} rev {}", sessionId, (Object)questionnaireSession.getRev());
            QuestionnaireSession previousSession = this.sessionCache.put((String)sessionId, questionnaireSession);
            if (previousSession == null) {
                LOGGER.debug("New session {} added to cache", sessionId);
                questionnaireSession.activate();
            }
            return questionnaireSession;
        }).orElseGet(() -> {
            LOGGER.warn("Cannot cache session without id.");
            return questionnaireSession;
        });
    }

    @Override
    public void forEach(@Nonnull Consumer<QuestionnaireSession> sessionConsumer) {
        this.sessionCache.values().forEach(sessionConsumer);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Object getNativeCache() {
        return this.sessionCache;
    }

    public Cache.ValueWrapper get(@Nonnull Object key) {
        return this.internalGet((String)key);
    }

    public <T> T get(@Nonnull Object key, Class<T> type) {
        Cache.ValueWrapper valueWrapper = this.internalGet((String)key);
        if (valueWrapper == null) {
            return null;
        }
        return (T)valueWrapper.get();
    }

    public <T> T get(@Nonnull Object key, @Nonnull Callable<T> valueLoader) {
        Cache.ValueWrapper valueWrapper = this.internalGet((String)key);
        if (valueWrapper == null) {
            try {
                return valueLoader.call();
            }
            catch (Exception e) {
                throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
            }
        }
        return (T)valueWrapper.get();
    }

    public void put(@Nonnull Object key, Object value) {
        this.putIfAbsent(key, value);
    }

    public Cache.ValueWrapper putIfAbsent(@Nonnull Object key, Object value) {
        if (!(key instanceof String) && !(key instanceof Optional)) {
            throw new IllegalArgumentException("questionnaireSession cache key must be String or Optional");
        }
        if (!(value instanceof QuestionnaireSession)) {
            throw new IllegalArgumentException("questionnaireSession cache value must be type of QuestionnaireSession");
        }
        QuestionnaireSession session = this.put((QuestionnaireSession)value);
        return () -> session;
    }

    public void evict(@Nonnull Object key) {
        this.evict((String)key, null);
    }

    public void clear() {
        String[] ids;
        for (String id : ids = this.sessionCache.keySet().toArray(new String[0])) {
            this.evict(id);
        }
    }
}

