/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.security.spring.ApiKeyCurrentUserProvider;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.OAuth2SpringSecurityCurrentUserProvider;
import io.dialob.security.user.CurrentUserProvider;
import io.dialob.security.user.DelegateCurrentUserProvider;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;

public class OAuth2AuthenticationStrategy
implements AuthenticationStrategy {
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;
    private final OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;

    public OAuth2AuthenticationStrategy(@NonNull GrantedAuthoritiesMapper grantedAuthoritiesMapper, @NonNull OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public HttpSecurity configureAuthentication(@NonNull HttpSecurity http, @Nullable AuthenticationManager authenticationManager) throws Exception {
        http = (HttpSecurity)http.oauth2Login().tokenEndpoint().accessTokenResponseClient(this.accessTokenResponseClient).and().loginPage("/oauth2/authorization/default").userInfoEndpoint().userAuthoritiesMapper(this.grantedAuthoritiesMapper).and().and();
        return (HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.ALWAYS).and();
    }

    public CurrentUserProvider currentUserProviderBean() {
        return new DelegateCurrentUserProvider(new CurrentUserProvider[]{new OAuth2SpringSecurityCurrentUserProvider(), new ApiKeyCurrentUserProvider()});
    }
}

