/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.boot.security.ApiServiceSecurityConfigurer;
import io.dialob.security.key.ServletRequestApiKeyExtractor;
import io.dialob.security.spring.apikey.ApiKeyAuthenticationProvider;
import io.dialob.security.spring.apikey.ApiKeyAuthoritiesProvider;
import io.dialob.security.spring.apikey.ApiKeyValidator;
import io.dialob.security.spring.apikey.ClientApiKeyService;
import io.dialob.security.spring.apikey.FixedClientApiKeyService;
import io.dialob.security.spring.apikey.HmacSHA256ApiKeyValidator;
import io.dialob.security.spring.apikey.RequestHeaderApiKeyExtractor;
import io.dialob.settings.DialobSettings;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="true")
@EnableWebSecurity
@Import(value={ApiServiceSecurityConfigurer.class})
public class SecurityConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfiguration.class);

    @Bean
    public ServletRequestApiKeyExtractor requestParameterServletApiKeyExtractor() {
        return new RequestHeaderApiKeyExtractor();
    }

    @Bean
    public ApiKeyValidator apiKeyValidator(DialobSettings apiSettings) {
        return new HmacSHA256ApiKeyValidator(apiSettings.getApi().getApiKeySalt().getBytes());
    }

    @Bean
    public ClientApiKeyService clientApiKeyService(DialobSettings apiSettings) {
        List apiKeys = apiSettings.getApi().getApiKeys();
        LOGGER.info("{} api keys found.", (Object)apiKeys.size());
        FixedClientApiKeyService.FixedClientApiKeyServiceBuilder builder = FixedClientApiKeyService.builder();
        apiKeys.forEach(apiKey -> builder.addKey(apiKey.getClientId(), apiKey.getHash(), apiKey.getTenantId(), apiKey.getPermissions()));
        return builder.build();
    }

    @Bean
    AuthenticationProvider apiKeyAuthenticationProvider(@NonNull ClientApiKeyService apiKeyService, @NonNull ApiKeyAuthoritiesProvider apiKeyAuthoritiesProvider, @NonNull ApiKeyValidator apiKeyValidator) {
        return new ApiKeyAuthenticationProvider(apiKeyService, apiKeyAuthoritiesProvider, apiKeyValidator);
    }

    @Bean
    public AuthenticationManager authenticationManager(List<AuthenticationProvider> providerList) {
        if (providerList.isEmpty()) {
            return authentication -> authentication;
        }
        return new ProviderManager(providerList);
    }
}

