/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.boot.security.WebUISecurityConfigurer;
import io.dialob.boot.settings.AdminApplicationSettings;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@Profile(value={"ui"})
public class AdminSecurityConfigurer
extends WebUISecurityConfigurer {
    private final ApplicationEventPublisher applicationEventPublisher;

    public AdminSecurityConfigurer(@NonNull AdminApplicationSettings settings, @NonNull ApplicationEventPublisher applicationEventPublisher, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy) {
        super(settings.getContextPath(), tenantPermissionEvaluator, authenticationStrategy);
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected HttpSecurity configurePermissions(HttpSecurity http) throws Exception {
        String contextPath = this.getContextPath();
        contextPath = StringUtils.removeEnd((String)contextPath, (String)"/");
        return (HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.securityMatcher(this.requestMatcher()).authorizeHttpRequests().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)(contextPath + "/swagger/**"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)(contextPath + "/swagger-resources"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)(contextPath + "/swagger-resources/**"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)(contextPath + "/swagger-ui/**"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)(contextPath + "/webjars/**"))})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/_uuids")})).hasAnyAuthority(new String[]{"questionnaires.post", "forms.post"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)(contextPath + "**"))})).hasAuthority("manager.view").anyRequest()).denyAll().and();
    }

    @Bean
    @Order
    SecurityFilterChain adminFilterChain(HttpSecurity http) throws Exception {
        return super.filterChain(http);
    }
}

