/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.FillController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.QuestionnaireApplicationSettings;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${fill.context-path:/fill}"})
public class FillController
extends BaseController {
    private final QuestionnaireApplicationSettings settings;
    private final PageSettingsProvider pageSettingsProvider;

    public FillController(QuestionnaireApplicationSettings settings, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(value={"/{questionnaireId}"}, produces={"text/html"})
    public String fill(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, @PathVariable(value="questionnaireId") String questionnaireId, CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        FormConnectionOptions formConnectionOptions = new FormConnectionOptions();
        formConnectionOptions.setQuestionnaireId(questionnaireId);
        formConnectionOptions.setUrl(this.settings.getSocketUrl() + "/" + questionnaireId);
        formConnectionOptions.setReviewUrl(this.settings.getReviewUrl() + "/" + questionnaireId);
        formConnectionOptions.setCsrf(cfrsToken);
        formConnectionOptions.setRestUrl(this.settings.getRestUrl() + "/" + questionnaireId);
        formConnectionOptions.setRestUrlBase(this.settings.getRestUrl());
        formConnectionOptions.setConnectionMode(this.settings.getConnectionMode());
        formConnectionOptions.setBackendApiUrl(this.settings.getBackendApiUrl());
        model.addAttribute("formConnectionOptions", (Object)formConnectionOptions);
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettingsByQuestionnaireId("fill", questionnaireId);
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }
}

