/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.boot.security.ApiServiceSecurityConfigurer;
import io.dialob.security.key.ServletRequestApiKeyExtractor;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.apikey.ApiKeyAuthoritiesProvider;
import io.dialob.security.spring.apikey.ApiKeyValidator;
import io.dialob.security.spring.apikey.ClientApiKeyService;
import io.dialob.security.spring.apikey.FixedClientApiKeyService;
import io.dialob.security.spring.apikey.HmacSHA256ApiKeyValidator;
import io.dialob.security.spring.apikey.RequestHeaderApiKeyExtractor;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"dialob.security.enabled"}, havingValue="true")
@EnableWebSecurity
public class SecurityConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfiguration.class);

    @Bean
    public ServletRequestApiKeyExtractor requestParameterServletApiKeyExtractor() {
        return new RequestHeaderApiKeyExtractor();
    }

    @Bean
    public ApiKeyValidator apiKeyValidator(DialobSettings apiSettings) {
        return new HmacSHA256ApiKeyValidator(apiSettings.getApi().getApiKeySalt().getBytes());
    }

    @Bean
    public ClientApiKeyService clientApiKeyService(DialobSettings apiSettings) {
        List apiKeys = apiSettings.getApi().getApiKeys();
        LOGGER.info("{} api keys found.", (Object)apiKeys.size());
        FixedClientApiKeyService.FixedClientApiKeyServiceBuilder builder = FixedClientApiKeyService.builder();
        apiKeys.forEach(apiKey -> builder.addKey(apiKey.getClientId(), apiKey.getHash(), apiKey.getTenantId(), apiKey.getPermissions()));
        return builder.build();
    }

    @Bean
    public static WebSecurityConfigurerAdapter apiServiceSecurityConfigurer(@NonNull Environment env, @NonNull ClientApiKeyService apiKeyService, @NonNull ApiKeyAuthoritiesProvider apiKeyAuthoritiesProvider, @NonNull ApiKeyValidator apiRequestValidator, @NonNull DialobSettings settings, @NonNull ServletRequestApiKeyExtractor keyRequestExtractor, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy) {
        return new ApiServiceSecurityConfigurer(apiKeyService, apiKeyAuthoritiesProvider, apiRequestValidator, settings, keyRequestExtractor, tenantPermissionEvaluator, authenticationStrategy, env.acceptsProfiles(Profiles.of((String[])new String[]{"!ui"}))).withOrder(120);
    }
}

